/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DefaultGcpRegionFactory;
import org.apache.beam.sdk.extensions.gcp.storage.NoopPathValidator;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ResetDateTimeProvider;
import org.apache.beam.sdk.testing.RestoreSystemProperties;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DataflowPipelineOptionsTest {
    @Rule
    public TestRule restoreSystemProperties = new RestoreSystemProperties();
    @Rule
    public ResetDateTimeProvider resetDateTimeProviderRule = new ResetDateTimeProvider();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testJobNameIsSet() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setJobName("TestJobName");
        Assert.assertEquals((Object)"TestJobName", (Object)options.getJobName());
    }

    @Test
    public void testUserNameIsNotSet() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().remove("user.name");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("TestApplication");
        List nameComponents = Splitter.on((char)'-').splitToList((CharSequence)options.getJobName());
        Assert.assertEquals((long)4L, (long)nameComponents.size());
        Assert.assertEquals((Object)"testapplication", nameComponents.get(0));
        Assert.assertEquals((Object)"", nameComponents.get(1));
        Assert.assertEquals((Object)"1208190706", nameComponents.get(2));
        Long.parseLong((String)nameComponents.get(3), 16);
        Assert.assertTrue((options.getJobName().length() <= 40 ? 1 : 0) != 0);
    }

    @Test
    public void testAppNameAndUserNameAreLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcdeabcdeabcdeabcdeabcdeabcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890123456789012345678901234567890");
        List nameComponents = Splitter.on((char)'-').splitToList((CharSequence)options.getJobName());
        Assert.assertEquals((long)4L, (long)nameComponents.size());
        Assert.assertEquals((Object)"a234567890123456789012345678901234567890", nameComponents.get(0));
        Assert.assertEquals((Object)"abcdeabcdeabcdeabcdeabcdeabcde", nameComponents.get(1));
        Assert.assertEquals((Object)"1208190706", nameComponents.get(2));
        Long.parseLong((String)nameComponents.get(3), 16);
    }

    @Test
    public void testAppNameIsLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890123456789012345678901234567890");
        List nameComponents = Splitter.on((char)'-').splitToList((CharSequence)options.getJobName());
        Assert.assertEquals((long)4L, (long)nameComponents.size());
        Assert.assertEquals((Object)"a234567890123456789012345678901234567890", nameComponents.get(0));
        Assert.assertEquals((Object)"abcde", nameComponents.get(1));
        Assert.assertEquals((Object)"1208190706", nameComponents.get(2));
        Long.parseLong((String)nameComponents.get(3), 16);
    }

    @Test
    public void testUserNameIsLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcdeabcdeabcdeabcdeabcdeabcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890");
        List nameComponents = Splitter.on((char)'-').splitToList((CharSequence)options.getJobName());
        Assert.assertEquals((long)4L, (long)nameComponents.size());
        Assert.assertEquals((Object)"a234567890", nameComponents.get(0));
        Assert.assertEquals((Object)"abcdeabcdeabcdeabcdeabcdeabcde", nameComponents.get(1));
        Assert.assertEquals((Object)"1208190706", nameComponents.get(2));
        Long.parseLong((String)nameComponents.get(3), 16);
    }

    @Test
    public void testUtf8UserNameAndApplicationNameIsNormalized() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "\u00f0i \u0131nt\u0259\u02c8n\u00e6\u0283\u0259n\u0259l ");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("f\u0259\u02c8n\u025bt\u0131k \u0259so\u028asi\u02c8e\u0131\u0283n");
        List nameComponents = Splitter.on((char)'-').splitToList((CharSequence)options.getJobName());
        Assert.assertEquals((long)4L, (long)nameComponents.size());
        Assert.assertEquals((Object)"f00n0t0k00so0si0e00n", nameComponents.get(0));
        Assert.assertEquals((Object)"0i00nt00n000n0l0", nameComponents.get(1));
        Assert.assertEquals((Object)"1208190706", nameComponents.get(2));
        Long.parseLong((String)nameComponents.get(3), 16);
    }

    @Test
    public void testStagingLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setTempLocation("gs://temp_location");
        options.setStagingLocation("gs://staging_location");
        Assert.assertEquals((Object)"gs://temp_location", (Object)options.getGcpTempLocation());
        Assert.assertEquals((Object)"gs://staging_location", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultToTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setTempLocation("gs://temp_location/");
        Assert.assertEquals((Object)"gs://temp_location/", (Object)options.getGcpTempLocation());
        Assert.assertEquals((Object)"gs://temp_location/staging/", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultToGcpTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setTempLocation("gs://temp_location/");
        options.setGcpTempLocation("gs://gcp_temp_location/");
        Assert.assertEquals((Object)"gs://gcp_temp_location/staging/", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultFlexRSGoal() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        Assert.assertEquals((Object)DataflowPipelineOptions.FlexResourceSchedulingGoal.UNSPECIFIED, (Object)options.getFlexRSGoal());
        options.setFlexRSGoal(DataflowPipelineOptions.FlexResourceSchedulingGoal.COST_OPTIMIZED);
        Assert.assertEquals((Object)DataflowPipelineOptions.FlexResourceSchedulingGoal.COST_OPTIMIZED, (Object)options.getFlexRSGoal());
    }

    @Test
    public void testDefaultNoneGcsTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setTempLocation("file://temp_location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation: failed to retrieve gcpTempLocation.");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Error constructing default value for gcpTempLocation")));
        options.getStagingLocation();
    }

    @Test
    public void testDefaultInvalidGcpTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setGcpTempLocation("file://temp_location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation: gcpTempLocation is not a valid GCS path");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Expected a valid 'gs://' path")));
        options.getStagingLocation();
    }

    @Test
    public void testDefaultStagingLocationUnset() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setProject("");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation");
        options.getStagingLocation();
    }

    @Test
    public void testDefaultGcpRegionUnset() {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class);){
            mocked.when(DefaultGcpRegionFactory::getRegionFromEnvironment).thenReturn(null);
            mocked.when(() -> DefaultGcpRegionFactory.getRegionFromGcloudCli((long)ArgumentMatchers.anyLong())).thenReturn((Object)"");
            DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
            Assert.assertEquals((Object)"", (Object)options.getRegion());
        }
    }

    @Test
    public void testDefaultGcpRegionUnsetIgnoresGcloudException() {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class);){
            mocked.when(DefaultGcpRegionFactory::getRegionFromEnvironment).thenReturn(null);
            mocked.when(() -> DefaultGcpRegionFactory.getRegionFromGcloudCli((long)ArgumentMatchers.anyLong())).thenThrow(new Throwable[]{new IOException()});
            DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
            Assert.assertEquals((Object)"", (Object)options.getRegion());
        }
    }

    @Test
    public void testDefaultGcpRegionFromEnvironment() {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class);){
            mocked.when(DefaultGcpRegionFactory::getRegionFromEnvironment).thenReturn((Object)"us-west1");
            DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
            Assert.assertEquals((Object)"us-west1", (Object)options.getRegion());
        }
    }

    @Test
    public void testDefaultGcpRegionFromGcloud() {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class);){
            mocked.when(DefaultGcpRegionFactory::getRegionFromEnvironment).thenReturn(null);
            mocked.when(() -> DefaultGcpRegionFactory.getRegionFromGcloudCli((long)ArgumentMatchers.anyLong())).thenReturn((Object)"us-west1");
            DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
            Assert.assertEquals((Object)"us-west1", (Object)options.getRegion());
        }
    }

    @Test(timeout=10000L)
    public void testGetRegionFromGcloudCliTimeout() {
        try (MockedStatic mocked = Mockito.mockStatic(DefaultGcpRegionFactory.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            mocked.when(DefaultGcpRegionFactory::startGcloud).thenReturn((Object)new Process(){

                @Override
                public OutputStream getOutputStream() {
                    return new OutputStream(){

                        @Override
                        public void write(int b) {
                        }
                    };
                }

                @Override
                public InputStream getInputStream() {
                    return new InputStream(){

                        @Override
                        public int read() {
                            return -1;
                        }
                    };
                }

                @Override
                public InputStream getErrorStream() {
                    return new InputStream(){

                        @Override
                        public int read() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            return 0;
                        }
                    };
                }

                @Override
                public int waitFor() {
                    return 0;
                }

                @Override
                public int exitValue() {
                    throw new IllegalThreadStateException("This mock process never terminates.");
                }

                @Override
                public void destroy() {
                }
            });
            Assert.assertThrows(TimeoutException.class, () -> DefaultGcpRegionFactory.getRegionFromGcloudCli((long)1L));
        }
    }
}

