/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowProfilingOptionsTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    @Test
    public void testOptionsObject() throws Exception {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--saveProfilesToGcs=path", "--profilingAgentConfiguration={\"interval\": 21}"}).as(DataflowPipelineOptions.class);
        MatcherAssert.assertThat((Object)options.getSaveProfilesToGcs(), (Matcher)Matchers.equalTo((Object)"path"));
        String json = MAPPER.writeValueAsString((Object)options);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"profilingAgentConfiguration\":{\"interval\":21}"));
    }
}

