/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.transforms;

import com.google.api.services.dataflow.Dataflow;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.gcp.storage.NoopPathValidator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DataflowGroupByKeyTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private Dataflow dataflow;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    private Pipeline createTestServiceRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setProject("someproject");
        options.setRegion("some-region1");
        options.setGcpTempLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(this.dataflow);
        return Pipeline.create((PipelineOptions)options);
    }

    @Test
    public void testGroupByKeyServiceUnbounded() {
        Pipeline p = this.createTestServiceRunner();
        PCollection input = (PCollection)p.apply((PTransform)new PTransform<PBegin, PCollection<KV<String, Integer>>>(){

            public PCollection<KV<String, Integer>> expand(PBegin input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()));
            }
        });
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("GroupByKey cannot be applied to non-bounded PCollection in the GlobalWindow without a trigger. Use a Window.into or Window.triggering transform prior to GroupByKey.");
        input.apply("GroupByKey", (PTransform)GroupByKey.create());
    }
}

