/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.transforms;

import com.google.api.services.dataflow.Dataflow;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.gcp.storage.NoopPathValidator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DataflowViewTest {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    @Mock
    private Dataflow dataflow;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    private Pipeline createTestBatchRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setProject("someproject");
        options.setRegion("some-region1");
        options.setGcpTempLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(this.dataflow);
        return Pipeline.create((PipelineOptions)options);
    }

    private Pipeline createTestStreamingRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowRunner.class);
        options.setStreaming(true);
        options.setProject("someproject");
        options.setRegion("some-region1");
        options.setGcpTempLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(this.dataflow);
        return Pipeline.create((PipelineOptions)options);
    }

    private void testViewUnbounded(Pipeline pipeline, PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>> view) {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to create a side-input view from input");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"non-bounded PCollection")));
        ((PCollection)pipeline.apply((PTransform)new PTransform<PBegin, PCollection<KV<String, Integer>>>(){

            public PCollection<KV<String, Integer>> expand(PBegin input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()));
            }
        })).apply(view);
    }

    @Test
    public void testViewUnboundedAsSingletonBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewUnboundedAsSingletonStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewUnboundedAsIterableBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewUnboundedAsIterableStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewUnboundedAsListBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewUnboundedAsListStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewUnboundedAsMapBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewUnboundedAsMapStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewUnboundedAsMultimapBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    @Test
    public void testViewUnboundedAsMultimapStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }
}

