/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.DefaultCoderCloudObjectTranslatorRegistrar;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroGeneratedUser;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class CloudObjectsTest {
    private static final Schema TEST_SCHEMA = Schema.builder().addBooleanField("bool").addByteField("int8").addInt16Field("int16").addInt32Field("int32").addInt64Field("int64").addFloatField("float").addDoubleField("double").addStringField("string").addArrayField("list_int32", Schema.FieldType.INT32).addLogicalTypeField("fixed_bytes", (Schema.LogicalType)FixedBytes.of((int)4)).build();
    private static org.apache.avro.Schema avroSchema = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"TestAvro\",\n \"fields\": []\n}");

    private static class RowIdentity
    implements SerializableFunction<Row, Row> {
        private RowIdentity() {
        }

        public Row apply(Row input) {
            return input;
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    private static class ArbitraryCoder
    extends StructuredCoder<Record> {
        private ArbitraryCoder() {
        }

        public void encode(Record value, OutputStream outStream) throws CoderException, IOException {
        }

        public Record decode(InputStream inStream) throws CoderException, IOException {
            return new Record();
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    private static class ObjectCoder
    extends CustomCoder<Object> {
        private ObjectCoder() {
        }

        public void encode(Object value, OutputStream outStream) throws CoderException, IOException {
        }

        public Object decode(InputStream inStream) throws CoderException, IOException {
            return new Object();
        }

        public boolean equals(@Nullable Object other) {
            return other != null && ((Object)((Object)this)).getClass().equals(other.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    private static class Record
    implements Serializable {
        private Record() {
        }
    }

    @RunWith(value=Parameterized.class)
    public static class DefaultCoders {
        @Parameterized.Parameter(value=0)
        public Coder<?> coder;

        @Parameterized.Parameters(name="{index}: {0}")
        public static Iterable<Coder<?>> data() {
            ImmutableList.Builder dataBuilder = ImmutableList.builder().add((Object)new ArbitraryCoder()).add((Object)new ObjectCoder()).add((Object)GlobalWindow.Coder.INSTANCE).add((Object)IntervalWindow.getCoder()).add((Object)TimestampPrefixingWindowCoder.of((Coder)IntervalWindow.getCoder())).add((Object)LengthPrefixCoder.of((Coder)VarLongCoder.of())).add((Object)IterableCoder.of((Coder)VarLongCoder.of())).add((Object)KvCoder.of((Coder)VarLongCoder.of(), (Coder)ByteArrayCoder.of())).add((Object)WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)VarLongCoder.of(), (Coder)ByteArrayCoder.of()), (Coder)IntervalWindow.getCoder())).add((Object)ByteArrayCoder.of()).add((Object)VarLongCoder.of()).add((Object)SerializableCoder.of(Record.class)).add((Object)AvroCoder.generic((org.apache.avro.Schema)avroSchema)).add((Object)AvroCoder.specific(AvroGeneratedUser.class)).add((Object)AvroCoder.reflect(Record.class)).add((Object)CollectionCoder.of((Coder)VarLongCoder.of())).add((Object)ListCoder.of((Coder)VarLongCoder.of())).add((Object)SetCoder.of((Coder)VarLongCoder.of())).add((Object)MapCoder.of((Coder)VarLongCoder.of(), (Coder)ByteArrayCoder.of())).add((Object)NullableCoder.of((Coder)IntervalWindow.getCoder())).add((Object)TimestampedValue.TimestampedValueCoder.of((Coder)VarLongCoder.of())).add((Object)UnionCoder.of((List)ImmutableList.of((Object)VarLongCoder.of(), (Object)ByteArrayCoder.of(), (Object)KvCoder.of((Coder)VarLongCoder.of(), (Coder)ByteArrayCoder.of())))).add((Object)CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)CoGbkResultSchema.of((List)ImmutableList.of((Object)new TupleTag(), (Object)new TupleTag())), (UnionCoder)UnionCoder.of((List)ImmutableList.of((Object)VarLongCoder.of(), (Object)ByteArrayCoder.of())))).add((Object)SchemaCoder.of((Schema)Schema.builder().build(), (TypeDescriptor)TypeDescriptors.rows(), (SerializableFunction)new RowIdentity(), (SerializableFunction)new RowIdentity())).add((Object)SchemaCoder.of((Schema)TEST_SCHEMA, (TypeDescriptor)TypeDescriptors.rows(), (SerializableFunction)new RowIdentity(), (SerializableFunction)new RowIdentity())).add((Object)RowCoder.of((Schema)TEST_SCHEMA));
            for (Class atomicCoder : DefaultCoderCloudObjectTranslatorRegistrar.KNOWN_ATOMIC_CODERS) {
                dataBuilder.add((Object)((Coder)InstanceBuilder.ofType((Class)atomicCoder).fromFactoryMethod("of").build()));
            }
            return dataBuilder.build();
        }

        @Test
        public void toAndFromCloudObject() throws Exception {
            CloudObject cloudObject = CloudObjects.asCloudObject(this.coder, null);
            Coder fromCloudObject = CloudObjects.coderFromCloudObject((CloudObject)cloudObject);
            Assert.assertEquals(this.coder.getClass(), fromCloudObject.getClass());
            Assert.assertEquals(this.coder, (Object)fromCloudObject);
        }

        @Test
        public void toAndFromCloudObjectWithSdkComponents() throws Exception {
            SdkComponents sdkComponents = SdkComponents.create();
            CloudObject cloudObject = CloudObjects.asCloudObject(this.coder, (SdkComponents)sdkComponents);
            Coder fromCloudObject = CloudObjects.coderFromCloudObject((CloudObject)cloudObject);
            Assert.assertEquals(this.coder.getClass(), fromCloudObject.getClass());
            Assert.assertEquals(this.coder, (Object)fromCloudObject);
            DefaultCoders.checkPipelineProtoCoderIds(this.coder, cloudObject, sdkComponents);
        }

        private static void checkPipelineProtoCoderIds(Coder<?> coder, CloudObject cloudObject, SdkComponents sdkComponents) throws Exception {
            List cloudComponents;
            if (CloudObjects.DATAFLOW_KNOWN_CODERS.contains(coder.getClass())) {
                Assert.assertFalse((boolean)cloudObject.containsKey((Object)"pipeline_proto_coder_id"));
            } else {
                Assert.assertTrue((boolean)cloudObject.containsKey((Object)"pipeline_proto_coder_id"));
                Assert.assertEquals((Object)sdkComponents.registerCoder(coder), (Object)((CloudObject)cloudObject.get((Object)"pipeline_proto_coder_id")).get((Object)"value"));
            }
            List expectedComponents = coder instanceof StructuredCoder ? ((StructuredCoder)coder).getComponents() : coder.getCoderArguments();
            Object cloudComponentsObject = cloudObject.get((Object)"component_encodings");
            if (cloudComponentsObject == null) {
                cloudComponents = Lists.newArrayList();
            } else {
                MatcherAssert.assertThat((Object)cloudComponentsObject, (Matcher)Matchers.instanceOf(List.class));
                cloudComponents = (List)cloudComponentsObject;
            }
            Assert.assertEquals((long)expectedComponents.size(), (long)cloudComponents.size());
            for (int i = 0; i < expectedComponents.size(); ++i) {
                DefaultCoders.checkPipelineProtoCoderIds((Coder)expectedComponents.get(i), (CloudObject)cloudComponents.get(i), sdkComponents);
            }
        }
    }

    @RunWith(value=JUnit4.class)
    public static class DefaultsPresentTest {
        @Test
        public void defaultCodersAllTested() {
            Set defaultCoderTranslators = new DefaultCoderCloudObjectTranslatorRegistrar().classesToTranslators().keySet();
            HashSet testedClasses = new HashSet();
            for (Coder<?> tested : DefaultCoders.data()) {
                if (tested instanceof ObjectCoder || tested instanceof ArbitraryCoder) {
                    testedClasses.add(CustomCoder.class);
                    MatcherAssert.assertThat(defaultCoderTranslators, (Matcher)Matchers.hasItem(CustomCoder.class));
                    continue;
                }
                if (AvroCoder.class.isAssignableFrom(tested.getClass())) {
                    testedClasses.add(AvroCoder.class);
                    MatcherAssert.assertThat(defaultCoderTranslators, (Matcher)Matchers.hasItem(AvroCoder.class));
                    continue;
                }
                testedClasses.add(tested.getClass());
                MatcherAssert.assertThat(defaultCoderTranslators, (Matcher)Matchers.hasItem(tested.getClass()));
            }
            HashSet missing = new HashSet();
            missing.addAll(defaultCoderTranslators);
            missing.removeAll(testedClasses);
            MatcherAssert.assertThat((String)"Coders with custom serializers should all be tested", missing, (Matcher)Matchers.emptyIterable());
        }

        @Test
        public void defaultCodersIncludesCustomCoder() {
            Set defaultCoders = new DefaultCoderCloudObjectTranslatorRegistrar().classesToTranslators().keySet();
            MatcherAssert.assertThat(defaultCoders, (Matcher)Matchers.hasItem(CustomCoder.class));
        }
    }
}

