/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.GcsStager;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;

public class GCSUploadMain {
    public static void main(String[] args) {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(DataflowPipelineOptions.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        GcsStager stager = GcsStager.fromOptions((PipelineOptions)options);
        stager.stageFiles(options.getFilesToStage().stream().map(source -> {
            try {
                File file = new File((String)source);
                HashCode hashCode = Files.asByteSource((File)file).hash(Hashing.sha256());
                return PackageUtil.StagedFile.of((String)source, (String)hashCode.toString(), (String)Environments.createStagingFileName((File)file, (HashCode)hashCode));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList()));
    }
}

