/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.auth.Credentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MonitoringUtilTest {
    private static final String PROJECT_ID = "someProject";
    private static final String REGION_ID = "thatRegion";
    private static final String JOB_ID = "1234";
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(MonitoringUtil.LoggingHandler.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testGetJobMessages() throws IOException {
        DataflowClient dataflowClient = (DataflowClient)Mockito.mock(DataflowClient.class);
        ListJobMessagesResponse firstResponse = new ListJobMessagesResponse();
        firstResponse.setJobMessages(new ArrayList());
        for (long i = 0L; i < 100L; ++i) {
            JobMessage message = new JobMessage();
            message.setId("message_" + i);
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant(i)));
            firstResponse.getJobMessages().add(message);
        }
        String pageToken = "page_token";
        firstResponse.setNextPageToken(pageToken);
        ListJobMessagesResponse secondResponse = new ListJobMessagesResponse();
        secondResponse.setJobMessages(new ArrayList());
        for (long i = 100L; i < 150L; ++i) {
            JobMessage message = new JobMessage();
            message.setId("message_" + i);
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant(i)));
            secondResponse.getJobMessages().add(message);
        }
        Mockito.when((Object)dataflowClient.listJobMessages(JOB_ID, null)).thenReturn((Object)firstResponse);
        Mockito.when((Object)dataflowClient.listJobMessages(JOB_ID, pageToken)).thenReturn((Object)secondResponse);
        MonitoringUtil util = new MonitoringUtil(dataflowClient);
        List messages = util.getJobMessages(JOB_ID, -1L);
        Assert.assertEquals((long)150L, (long)messages.size());
    }

    @Test
    public void testToStateNormal() {
        Assert.assertEquals((Object)PipelineResult.State.UNKNOWN, (Object)MonitoringUtil.toState((String)"JOB_STATE_UNKNOWN"));
        Assert.assertEquals((Object)PipelineResult.State.STOPPED, (Object)MonitoringUtil.toState((String)"JOB_STATE_STOPPED"));
        Assert.assertEquals((Object)PipelineResult.State.RUNNING, (Object)MonitoringUtil.toState((String)"JOB_STATE_RUNNING"));
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)MonitoringUtil.toState((String)"JOB_STATE_DONE"));
        Assert.assertEquals((Object)PipelineResult.State.FAILED, (Object)MonitoringUtil.toState((String)"JOB_STATE_FAILED"));
        Assert.assertEquals((Object)PipelineResult.State.CANCELLED, (Object)MonitoringUtil.toState((String)"JOB_STATE_CANCELLED"));
        Assert.assertEquals((Object)PipelineResult.State.UPDATED, (Object)MonitoringUtil.toState((String)"JOB_STATE_UPDATED"));
        Assert.assertEquals((Object)PipelineResult.State.RUNNING, (Object)MonitoringUtil.toState((String)"JOB_STATE_DRAINING"));
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)MonitoringUtil.toState((String)"JOB_STATE_DRAINED"));
    }

    @Test
    public void testToStateWithNullReturnsUnrecognized() {
        Assert.assertEquals((Object)PipelineResult.State.UNRECOGNIZED, (Object)MonitoringUtil.toState(null));
    }

    @Test
    public void testToStateWithOtherValueReturnsUnknown() {
        Assert.assertEquals((Object)PipelineResult.State.UNRECOGNIZED, (Object)MonitoringUtil.toState((String)"FOO_BAR_BAZ"));
    }

    @Test
    public void testDontOverrideEndpointWithDefaultApi() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setRegion(REGION_ID);
        options.setGcpCredential((Credentials)new TestCredential());
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"gcloud dataflow jobs --project=someProject cancel --region=thatRegion 1234", (Object)cancelCommand);
    }

    @Test
    public void testOverridesEndpointWithStagedDataflowEndpoint() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setRegion(REGION_ID);
        options.setGcpCredential((Credentials)new TestCredential());
        String stagingDataflowEndpoint = "v0neverExisted";
        options.setDataflowEndpoint(stagingDataflowEndpoint);
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"CLOUDSDK_API_ENDPOINT_OVERRIDES_DATAFLOW=https://dataflow.googleapis.com/v0neverExisted/ gcloud dataflow jobs --project=someProject cancel --region=thatRegion 1234", (Object)cancelCommand);
    }

    @Test
    public void testLoggingHandler() {
        DateTime errorTime = new DateTime(1000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime warningTime = new DateTime(2000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime basicTime = new DateTime(3000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime detailedTime = new DateTime(4000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime debugTime = new DateTime(5000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime unknownTime = new DateTime(6000L, (Chronology)ISOChronology.getInstanceUTC());
        JobMessage errorJobMessage = new JobMessage();
        errorJobMessage.setMessageImportance("JOB_MESSAGE_ERROR");
        errorJobMessage.setMessageText("ERRORERROR");
        errorJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)errorTime));
        JobMessage warningJobMessage = new JobMessage();
        warningJobMessage.setMessageImportance("JOB_MESSAGE_WARNING");
        warningJobMessage.setMessageText("WARNINGWARNING");
        warningJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)warningTime));
        JobMessage basicJobMessage = new JobMessage();
        basicJobMessage.setMessageImportance("JOB_MESSAGE_BASIC");
        basicJobMessage.setMessageText("BASICBASIC");
        basicJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)basicTime));
        JobMessage detailedJobMessage = new JobMessage();
        detailedJobMessage.setMessageImportance("JOB_MESSAGE_DETAILED");
        detailedJobMessage.setMessageText("DETAILEDDETAILED");
        detailedJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)detailedTime));
        JobMessage debugJobMessage = new JobMessage();
        debugJobMessage.setMessageImportance("JOB_MESSAGE_DEBUG");
        debugJobMessage.setMessageText("DEBUGDEBUG");
        debugJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)debugTime));
        JobMessage unknownJobMessage = new JobMessage();
        unknownJobMessage.setMessageImportance("JOB_MESSAGE_UNKNOWN");
        unknownJobMessage.setMessageText("UNKNOWNUNKNOWN");
        unknownJobMessage.setTime("");
        JobMessage emptyJobMessage = new JobMessage();
        emptyJobMessage.setMessageImportance("JOB_MESSAGE_EMPTY");
        emptyJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)unknownTime));
        new MonitoringUtil.LoggingHandler().process(Arrays.asList(errorJobMessage, warningJobMessage, basicJobMessage, detailedJobMessage, debugJobMessage, unknownJobMessage));
        this.expectedLogs.verifyError("ERRORERROR");
        this.expectedLogs.verifyError(errorTime.toString());
        this.expectedLogs.verifyWarn("WARNINGWARNING");
        this.expectedLogs.verifyWarn(warningTime.toString());
        this.expectedLogs.verifyInfo("BASICBASIC");
        this.expectedLogs.verifyInfo(basicTime.toString());
        this.expectedLogs.verifyInfo("DETAILEDDETAILED");
        this.expectedLogs.verifyInfo(detailedTime.toString());
        this.expectedLogs.verifyDebug("DEBUGDEBUG");
        this.expectedLogs.verifyDebug(debugTime.toString());
        this.expectedLogs.verifyTrace("UNKNOWN TIMESTAMP");
        this.expectedLogs.verifyTrace("UNKNOWNUNKNOWN");
        this.expectedLogs.verifyNotLogged(unknownTime.toString());
    }
}

