/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.storage.model.StorageObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.RegexMatcher;
import org.apache.beam.sdk.util.FastNanoClockAndSleeper;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.FileWriteMode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.LineReader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class PackageUtilTest {
    @Rule
    public ExpectedLogs logged = ExpectedLogs.none(PackageUtil.class);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public FastNanoClockAndSleeper fastNanoClockAndSleeper = new FastNanoClockAndSleeper();
    @Mock
    GcsUtil mockGcsUtil;
    private CreateOptions createOptions;
    private PackageUtil defaultPackageUtil;
    static final GcsPath STAGING_GCS_PATH = GcsPath.fromComponents((String)"somebucket", (String)"base/path/");
    static final String STAGING_PATH = STAGING_GCS_PATH.toString();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        GcsOptions pipelineOptions = (GcsOptions)PipelineOptionsFactory.as(GcsOptions.class);
        pipelineOptions.setGcsUtil(this.mockGcsUtil);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)pipelineOptions);
        this.createOptions = ((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("application/octet-stream")).build();
        this.defaultPackageUtil = PackageUtil.withDefaultThreadPool();
    }

    @After
    public void teardown() {
        this.defaultPackageUtil.close();
    }

    private File makeFileWithContents(String name, String contents) throws Exception {
        File tmpFile = this.tmpFolder.newFile(name);
        Files.asCharSink((File)tmpFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)contents);
        Assert.assertTrue((boolean)tmpFile.setLastModified(0L));
        return tmpFile;
    }

    private static PackageUtil.PackageAttributes makePackageAttributes(File file, @Nullable String overridePackageName) throws IOException {
        PackageUtil.StagedFile stagedFile = PackageUtilTest.makeStagedFile(file.getPath());
        PackageUtil.PackageAttributes attributes = PackageUtil.PackageAttributes.forFileToStage((String)stagedFile.getSource(), (String)stagedFile.getSha256(), (String)stagedFile.getDestination(), (String)STAGING_PATH);
        if (overridePackageName != null) {
            attributes = attributes.withPackageName(overridePackageName);
        }
        return attributes;
    }

    private static PackageUtil.StagedFile makeStagedFile(String source) throws IOException {
        return PackageUtilTest.makeStagedFile(source, null);
    }

    private static PackageUtil.StagedFile makeStagedFile(String source, String destName) throws IOException {
        HashCode hashCode;
        File sourceFile;
        File file = new File(source);
        if (file.exists()) {
            sourceFile = file.isDirectory() ? PackageUtilTest.zipDirectory(file) : file;
            hashCode = Files.asByteSource((File)sourceFile).hash(Hashing.sha256());
        } else {
            sourceFile = file;
            hashCode = Hashing.sha256().hashBytes(new byte[0]);
        }
        String destination = destName == null ? Environments.createStagingFileName((File)file, (HashCode)hashCode) : destName;
        return PackageUtil.StagedFile.of((String)sourceFile.getPath(), (String)hashCode.toString(), (String)destination);
    }

    private static File zipDirectory(File directory) throws IOException {
        File tempDir = Files.createTempDir();
        File sourceFile = new File(tempDir, directory.getName() + ".jar");
        ZipFiles.zipDirectory((File)directory, (File)sourceFile);
        return sourceFile;
    }

    @Test
    public void testFileWithExtensionPackageNamingAndSize() throws Exception {
        String contents = "This is a test!";
        File tmpFile = this.makeFileWithContents("file.txt", contents);
        PackageUtil.PackageAttributes attr = PackageUtilTest.makePackageAttributes(tmpFile, null);
        DataflowPackage target = attr.getDestination();
        MatcherAssert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".txt"));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + target.getName())));
        MatcherAssert.assertThat((Object)attr.getSize(), (Matcher)org.hamcrest.Matchers.equalTo((Object)contents.length()));
    }

    @Test
    public void testPackageNamingWithFileNoExtension() throws Exception {
        File tmpFile = this.makeFileWithContents("file", "This is a test!");
        DataflowPackage target = PackageUtilTest.makePackageAttributes(tmpFile, null).getDestination();
        MatcherAssert.assertThat((Object)Files.getFileExtension((String)target.getName()), (Matcher)org.hamcrest.Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + target.getName())));
    }

    @Test
    public void testPackageNamingWithDirectory() throws Exception {
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        DataflowPackage target = PackageUtilTest.makePackageAttributes(tmpDirectory, null).getDestination();
        MatcherAssert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".jar"));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + target.getName())));
    }

    @Test
    public void testPackageNamingWithFilesHavingSameContentsAndSameNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.makeFileWithContents("folder1/folderA/sameName", "This is a test!");
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDestination();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.makeFileWithContents("folder2/folderA/sameName", "This is a test!");
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDestination();
        Assert.assertEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageNamingWithFilesHavingSameContentsButDifferentNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.makeFileWithContents("folder1/folderA/uniqueName1", "This is a test!");
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDestination();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.makeFileWithContents("folder2/folderA/uniqueName2", "This is a test!");
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDestination();
        Assert.assertNotEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertNotEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageNamingWithDirectoriesHavingSameContentsButDifferentNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.tmpFolder.newFolder(new String[]{"folder1", "folderA", "uniqueName1"});
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDestination();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.tmpFolder.newFolder(new String[]{"folder2", "folderA", "uniqueName2"});
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDestination();
        Assert.assertNotEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertNotEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageUploadWithLargeClasspathLogsWarning() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((StorageObject)this.createStorageObject(STAGING_PATH, tmpFile.length()))));
        LinkedList classpathElements = Lists.newLinkedList();
        for (int i = 0; i < 1005; ++i) {
            String eltName = "element" + i;
            classpathElements.add(PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath(), eltName));
        }
        this.defaultPackageUtil.stageClasspathElements((Collection)classpathElements, STAGING_PATH, this.createOptions);
        this.logged.verifyWarn("Your classpath contains 1005 elements, which Google Cloud Dataflow");
    }

    @Test
    public void testPackageUploadWithFileSucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        String contents = "This is a test!";
        File tmpFile = this.makeFileWithContents("file.txt", contents);
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenReturn((Object)pipe.sink());
        List targets = this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath())), STAGING_PATH, this.createOptions);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        MatcherAssert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".txt"));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + target.getName())));
        MatcherAssert.assertThat((Object)new LineReader((Readable)Channels.newReader((ReadableByteChannel)pipe.source(), StandardCharsets.UTF_8.name())).readLine(), (Matcher)org.hamcrest.Matchers.equalTo((Object)contents));
    }

    @Test
    public void testStagingPreservesClasspath() throws Exception {
        File smallFile = this.makeFileWithContents("small.txt", "small");
        File largeFile = this.makeFileWithContents("large.log", "large contents");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenAnswer(invocation -> Pipe.open().sink());
        List targets = this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(smallFile.getAbsolutePath()), (Object)PackageUtilTest.makeStagedFile(largeFile.getAbsolutePath())), STAGING_PATH, this.createOptions);
        MatcherAssert.assertThat((Object)((DataflowPackage)targets.get(0)).getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".txt"));
        MatcherAssert.assertThat((Object)((DataflowPackage)targets.get(1)).getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".log"));
    }

    @Test
    public void testPackageUploadWithDirectorySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        this.tmpFolder.newFolder(new String[]{"folder", "empty_directory"});
        this.tmpFolder.newFolder(new String[]{"folder", "directory"});
        this.makeFileWithContents("folder/file.txt", "This is a test!");
        this.makeFileWithContents("folder/directory/file.txt", "This is also a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenReturn((Object)pipe.sink());
        this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpDirectory.getAbsolutePath())), STAGING_PATH, this.createOptions);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        ArrayList<String> zipEntryNames = new ArrayList<String>();
        try (ZipInputStream inputStream = new ZipInputStream(Channels.newInputStream(pipe.source()));){
            ZipEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                zipEntryNames.add(entry.getName());
                entry = inputStream.getNextEntry();
            }
        }
        MatcherAssert.assertThat(zipEntryNames, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"directory/file.txt", "empty_directory/", "file.txt"}));
    }

    @Test
    public void testPackageUploadWithEmptyDirectorySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenReturn((Object)pipe.sink());
        List targets = this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpDirectory.getAbsolutePath())), STAGING_PATH, this.createOptions);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        MatcherAssert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.endsWith((String)".jar"));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + target.getName())));
        try (ZipInputStream zipInputStream = new ZipInputStream(Channels.newInputStream(pipe.source()));){
            Assert.assertNull((Object)zipInputStream.getNextEntry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testPackageUploadFailsWhenIOExceptionThrown() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenThrow(new Throwable[]{new IOException("Fake Exception: Upload error")});
        try (PackageUtil directPackageUtil = PackageUtil.withExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());){
            directPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath())), STAGING_PATH, arg_0 -> ((FastNanoClockAndSleeper)this.fastNanoClockAndSleeper).sleep(arg_0), this.createOptions);
        }
        catch (Throwable throwable) {
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).getObjects(Matchers.anyListOf(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
            throw throwable;
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageUploadFailsWithPermissionsErrorGivesDetailedMessage() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenThrow(new Throwable[]{new IOException("Failed to write to GCS path " + STAGING_PATH, (Throwable)PackageUtilTest.googleJsonResponseException(403, "Permission denied", "Test message"))});
        try (PackageUtil directPackageUtil = PackageUtil.withExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());){
            directPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath())), STAGING_PATH, arg_0 -> ((FastNanoClockAndSleeper)this.fastNanoClockAndSleeper).sleep(arg_0), this.createOptions);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException e) {
            try {
                MatcherAssert.assertThat((String)"Expected RuntimeException wrapping IOException.", (Object)e.getCause(), (Matcher)org.hamcrest.Matchers.instanceOf(RuntimeException.class));
                MatcherAssert.assertThat((String)"Expected IOException containing detailed message.", (Object)e.getCause().getCause(), (Matcher)org.hamcrest.Matchers.instanceOf(IOException.class));
                MatcherAssert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"Uploaded failed due to permissions error"), (Matcher)org.hamcrest.Matchers.containsString((String)"Stale credentials can be resolved by executing 'gcloud auth application-default login'")));
            }
            catch (Throwable throwable) {
                ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
                ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
                throw throwable;
            }
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageUploadEventuallySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenThrow(new Throwable[]{new IOException("Fake Exception: 410 Gone")}).thenThrow(new Throwable[]{new IOException("Fake Exception: 412 Precondition Failed")}).thenReturn((Object)pipe.sink());
        try (PackageUtil directPackageUtil = PackageUtil.withExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());){
            directPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath())), STAGING_PATH, arg_0 -> ((FastNanoClockAndSleeper)this.fastNanoClockAndSleeper).sleep(arg_0), this.createOptions);
        }
        catch (Throwable throwable) {
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)3))).getObjects(Matchers.anyListOf(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)3))).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
            throw throwable;
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)3))).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)3))).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadIsSkippedWhenFileAlreadyExists() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((StorageObject)this.createStorageObject(STAGING_PATH, tmpFile.length()))));
        this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath())), STAGING_PATH, this.createOptions);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadIsNotSkippedWhenSizesAreDifferent() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        this.tmpFolder.newFolder(new String[]{"folder", "empty_directory"});
        this.tmpFolder.newFolder(new String[]{"folder", "directory"});
        this.makeFileWithContents("folder/file.txt", "This is a test!");
        this.makeFileWithContents("folder/directory/file.txt", "This is also a test!");
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((StorageObject)this.createStorageObject(STAGING_PATH, Long.MAX_VALUE))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenReturn((Object)pipe.sink());
        this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpDirectory.getAbsolutePath())), STAGING_PATH, this.createOptions);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadWithExplicitPackageName() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        String overriddenName = "alias.txt";
        Mockito.when((Object)this.mockGcsUtil.getObjects(Matchers.anyListOf(GcsPath.class))).thenReturn((Object)ImmutableList.of((Object)GcsUtil.StorageObjectOrIOException.create((IOException)new FileNotFoundException("some/path"))));
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class))).thenReturn((Object)pipe.sink());
        List targets = this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(tmpFile.getAbsolutePath(), "alias.txt")), STAGING_PATH, this.createOptions);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).getObjects(Matchers.anyListOf(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), (GcsUtil.CreateOptions)Matchers.any(GcsUtil.CreateOptions.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        MatcherAssert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"alias.txt"));
        MatcherAssert.assertThat((Object)target.getLocation(), (Matcher)RegexMatcher.matches((String)(STAGING_PATH + "alias.txt")));
    }

    @Test
    public void testPackageUploadIsSkippedWithNonExistentResource() throws Exception {
        String nonExistentFile = FileSystems.matchNewResource((String)this.tmpFolder.getRoot().getPath(), (boolean)true).resolve("non-existent-file", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.defaultPackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)PackageUtilTest.makeStagedFile(nonExistentFile)), STAGING_PATH, this.createOptions));
    }

    private static GoogleJsonResponseException googleJsonResponseException(int status, final String reason, final String message) throws IOException {
        GsonFactory jsonFactory = new GsonFactory();
        MockHttpTransport transport = new MockHttpTransport((JsonFactory)jsonFactory, status){
            final /* synthetic */ JsonFactory val$jsonFactory;
            final /* synthetic */ int val$status;
            {
                this.val$jsonFactory = jsonFactory;
                this.val$status = n;
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
                errorInfo.setReason(reason);
                errorInfo.setMessage(message);
                errorInfo.setFactory(this.val$jsonFactory);
                GenericJson error = new GenericJson();
                error.set("code", (Object)this.val$status);
                error.set("errors", Arrays.asList(errorInfo));
                error.setFactory(this.val$jsonFactory);
                GenericJson errorResponse = new GenericJson();
                errorResponse.set("error", (Object)error);
                errorResponse.setFactory(this.val$jsonFactory);
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setContent(errorResponse.toPrettyString()).setContentType("application/json; charset=UTF-8").setStatusCode(this.val$status));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        return GoogleJsonResponseException.from((JsonFactory)jsonFactory, (HttpResponse)response);
    }

    private StorageObject createStorageObject(String gcsFilename, long fileSize) {
        GcsPath gcsPath = GcsPath.fromUri((String)gcsFilename);
        return new StorageObject().setBucket(gcsPath.getBucket()).setName(gcsPath.getObject()).setSize(BigInteger.valueOf(fileSize));
    }
}

