/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.beam.runners.dataflow.util.RandomAccessData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.CoderProperties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RandomAccessDataTest {
    private static final byte[] TEST_DATA_A = new byte[]{1, 2, 3};
    private static final byte[] TEST_DATA_B = new byte[]{6, 5, 4, 3};
    private static final byte[] TEST_DATA_C = new byte[]{6, 5, 3, 3};
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCoder() throws Exception {
        RandomAccessData streamA = new RandomAccessData();
        streamA.asOutputStream().write(TEST_DATA_A);
        RandomAccessData streamB = new RandomAccessData();
        streamB.asOutputStream().write(TEST_DATA_A);
        CoderProperties.coderDecodeEncodeEqual((Coder)RandomAccessData.RandomAccessDataCoder.of(), (Object)streamA);
        CoderProperties.coderDeterministic((Coder)RandomAccessData.RandomAccessDataCoder.of(), (Object)streamA, (Object)streamB);
        CoderProperties.coderConsistentWithEquals((Coder)RandomAccessData.RandomAccessDataCoder.of(), (Object)streamA, (Object)streamB);
        CoderProperties.coderSerializable((Coder)RandomAccessData.RandomAccessDataCoder.of());
        CoderProperties.structuralValueConsistentWithEquals((Coder)RandomAccessData.RandomAccessDataCoder.of(), (Object)streamA, (Object)streamB);
        Assert.assertTrue((boolean)RandomAccessData.RandomAccessDataCoder.of().isRegisterByteSizeObserverCheap(streamA));
        Assert.assertEquals((long)4L, (long)RandomAccessData.RandomAccessDataCoder.of().getEncodedElementByteSize(streamA));
    }

    @Test
    public void testCoderWithPositiveInfinityIsError() throws Exception {
        this.expectedException.expect(CoderException.class);
        this.expectedException.expectMessage("Positive infinity can not be encoded");
        RandomAccessData.RandomAccessDataCoder.of().encode(RandomAccessData.POSITIVE_INFINITY, (OutputStream)new ByteArrayOutputStream(), Coder.Context.OUTER);
    }

    @Test
    public void testLexicographicalComparator() throws Exception {
        RandomAccessData streamA = new RandomAccessData();
        streamA.asOutputStream().write(TEST_DATA_A);
        RandomAccessData streamB = new RandomAccessData();
        streamB.asOutputStream().write(TEST_DATA_B);
        RandomAccessData streamC = new RandomAccessData();
        streamC.asOutputStream().write(TEST_DATA_C);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(streamA, streamB) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(streamB, streamA) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(streamB, streamB) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.commonPrefixLength(streamB, streamC));
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(streamB, streamC, 3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(streamA, RandomAccessData.POSITIVE_INFINITY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(RandomAccessData.POSITIVE_INFINITY, RandomAccessData.POSITIVE_INFINITY) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RandomAccessData.UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(RandomAccessData.POSITIVE_INFINITY, streamA) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        RandomAccessData streamA = new RandomAccessData();
        streamA.asOutputStream().write(TEST_DATA_A);
        Assert.assertEquals((Object)streamA, (Object)streamA);
        Assert.assertEquals((long)streamA.hashCode(), (long)streamA.hashCode());
        RandomAccessData streamACopy = new RandomAccessData();
        streamACopy.asOutputStream().write(TEST_DATA_A);
        Assert.assertEquals((Object)streamA, (Object)streamACopy);
        Assert.assertEquals((long)streamA.hashCode(), (long)streamACopy.hashCode());
        RandomAccessData streamB = new RandomAccessData();
        streamB.asOutputStream().write(new byte[]{1, 2, 4});
        Assert.assertNotEquals((Object)streamA, (Object)streamB);
        Assert.assertNotEquals((long)streamA.hashCode(), (long)streamB.hashCode());
        streamB.asOutputStream().write(TEST_DATA_B);
        Assert.assertNotEquals((Object)streamA, (Object)streamB);
        Assert.assertNotEquals((long)streamA.hashCode(), (long)streamB.hashCode());
    }

    @Test
    public void testResetTo() throws Exception {
        RandomAccessData stream = new RandomAccessData();
        stream.asOutputStream().write(TEST_DATA_A);
        stream.resetTo(1);
        Assert.assertEquals((long)1L, (long)stream.size());
        stream.asOutputStream().write(TEST_DATA_A);
        Assert.assertArrayEquals((byte[])new byte[]{1, 1, 2, 3}, (byte[])Arrays.copyOf(stream.array(), stream.size()));
    }

    @Test
    public void testAsInputStream() throws Exception {
        RandomAccessData stream = new RandomAccessData();
        stream.asOutputStream().write(TEST_DATA_A);
        InputStream in = stream.asInputStream(1, 1);
        Assert.assertEquals((long)2L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        in.close();
    }

    @Test
    public void testReadFrom() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(TEST_DATA_A);
        RandomAccessData stream = new RandomAccessData();
        stream.readFrom((InputStream)bais, 3, 2);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 1, 2}, (byte[])Arrays.copyOf(stream.array(), stream.size()));
        bais.close();
    }

    @Test
    public void testWriteTo() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RandomAccessData stream = new RandomAccessData();
        stream.asOutputStream().write(TEST_DATA_B);
        stream.writeTo((OutputStream)baos, 1, 2);
        Assert.assertArrayEquals((byte[])new byte[]{5, 4}, (byte[])baos.toByteArray());
        baos.close();
    }

    @Test
    public void testThatRandomAccessDataGrowsWhenResettingToPositionBeyondEnd() throws Exception {
        RandomAccessData stream = new RandomAccessData(0);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])stream.array());
        stream.resetTo(3);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0}, (byte[])stream.array());
    }

    @Test
    public void testThatRandomAccessDataGrowsWhenReading() throws Exception {
        RandomAccessData stream = new RandomAccessData(0);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])stream.array());
        stream.readFrom((InputStream)new ByteArrayInputStream(TEST_DATA_A), 0, TEST_DATA_A.length);
        Assert.assertArrayEquals((byte[])TEST_DATA_A, (byte[])Arrays.copyOf(stream.array(), TEST_DATA_A.length));
    }

    @Test
    public void testIncrement() throws Exception {
        Assert.assertEquals((Object)new RandomAccessData(new byte[]{0, 1}), (Object)new RandomAccessData(new byte[]{0, 0}).increment());
        Assert.assertEquals((Object)new RandomAccessData(new byte[]{1, -1}), (Object)new RandomAccessData(new byte[]{0, -1}).increment());
        Assert.assertSame((Object)RandomAccessData.POSITIVE_INFINITY, (Object)new RandomAccessData(new byte[0]).increment());
        Assert.assertSame((Object)RandomAccessData.POSITIVE_INFINITY, (Object)new RandomAccessData(new byte[]{-1}).increment());
        Assert.assertSame((Object)RandomAccessData.POSITIVE_INFINITY, (Object)RandomAccessData.POSITIVE_INFINITY.increment());
    }
}

