/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.Structs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StructsTest {
    private List<Map<String, Object>> makeCloudObjects() {
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>();
        CloudObject o = CloudObject.forClassName((String)"string");
        Structs.addString((Map)o, (String)"singletonStringKey", (String)"stringValue");
        objects.add((Map<String, Object>)o);
        o = CloudObject.forClassName((String)"long");
        Structs.addLong((Map)o, (String)"singletonLongKey", (long)42L);
        objects.add((Map<String, Object>)o);
        return objects;
    }

    private Map<String, Object> makeCloudDictionary() {
        HashMap<String, Object> o = new HashMap<String, Object>();
        Structs.addList(o, (String)"emptyKey", Collections.emptyList());
        Structs.addNull(o, (String)"noStringsKey");
        Structs.addString(o, (String)"singletonStringKey", (String)"stringValue");
        Structs.addStringList(o, (String)"multipleStringsKey", Arrays.asList("hi", "there", "bob"));
        Structs.addLongs(o, (String)"multipleLongsKey", (long[])new long[]{47L, 0x40000000000L, -5L});
        Structs.addLong(o, (String)"singletonLongKey", (long)42L);
        Structs.addDouble(o, (String)"singletonDoubleKey", (Double)Math.PI);
        Structs.addBoolean(o, (String)"singletonBooleanKey", (boolean)true);
        Structs.addNull(o, (String)"noObjectsKey");
        Structs.addList(o, (String)"multipleObjectsKey", this.makeCloudObjects());
        return o;
    }

    @Test
    public void testGetStringParameter() throws Exception {
        Map<String, Object> o = this.makeCloudDictionary();
        Assert.assertEquals((Object)"stringValue", (Object)Structs.getString(o, (String)"singletonStringKey"));
        Assert.assertEquals((Object)"stringValue", (Object)Structs.getString(o, (String)"singletonStringKey", (String)"defaultValue"));
        Assert.assertEquals((Object)"defaultValue", (Object)Structs.getString(o, (String)"missingKey", (String)"defaultValue"));
        try {
            Structs.getString(o, (String)"missingKey");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"didn't find required parameter missingKey"));
        }
        try {
            Structs.getString(o, (String)"noStringsKey");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a string"));
        }
        MatcherAssert.assertThat((Object)Structs.getStrings(o, (String)"noStringsKey", null), (Matcher)Matchers.emptyIterable());
        MatcherAssert.assertThat(Structs.getObject(o, (String)"noStringsKey").keySet(), (Matcher)Matchers.emptyIterable());
        MatcherAssert.assertThat(Structs.getDictionary(o, (String)"noStringsKey").keySet(), (Matcher)Matchers.emptyIterable());
        MatcherAssert.assertThat(Structs.getDictionary(o, (String)"noStringsKey", null).keySet(), (Matcher)Matchers.emptyIterable());
        try {
            Structs.getString(o, (String)"multipleStringsKey");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a string"));
        }
        try {
            Structs.getString(o, (String)"emptyKey");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a string"));
        }
    }

    @Test
    public void testGetBooleanParameter() throws Exception {
        Map<String, Object> o = this.makeCloudDictionary();
        Assert.assertTrue((boolean)Structs.getBoolean(o, (String)"singletonBooleanKey", (Boolean)false));
        Assert.assertFalse((boolean)Structs.getBoolean(o, (String)"missingKey", (Boolean)false));
        try {
            Structs.getBoolean(o, (String)"emptyKey", (Boolean)false);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a boolean"));
        }
    }

    @Test
    public void testGetLongParameter() throws Exception {
        Map<String, Object> o = this.makeCloudDictionary();
        Assert.assertEquals((Object)42L, (Object)Structs.getLong(o, (String)"singletonLongKey", (Long)666L));
        Assert.assertEquals((Object)42, (Object)Structs.getInt(o, (String)"singletonLongKey", (Integer)666));
        Assert.assertEquals((Object)666L, (Object)Structs.getLong(o, (String)"missingKey", (Long)666L));
        try {
            Structs.getLong(o, (String)"emptyKey", (Long)666L);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a long"));
        }
        try {
            Structs.getInt(o, (String)"emptyKey", (Integer)666);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not an int"));
        }
    }

    @Test
    public void testGetListOfMaps() throws Exception {
        Map<String, Object> o = this.makeCloudDictionary();
        Assert.assertEquals(this.makeCloudObjects(), (Object)Structs.getListOfMaps(o, (String)"multipleObjectsKey", null));
        try {
            Structs.getListOfMaps(o, (String)"singletonLongKey", null);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception exn) {
            MatcherAssert.assertThat((Object)exn.toString(), (Matcher)Matchers.containsString((String)"not a list"));
        }
    }
}

