/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;

class CloudObjectTranslators {
    private static final String CODER_FIELD = "serialized_coder";
    private static final String TYPE_FIELD = "type";

    private CloudObjectTranslators() {
    }

    private static CloudObject addComponents(CloudObject base, List<? extends Coder<?>> components, SdkComponents sdkComponents) {
        if (!components.isEmpty()) {
            ArrayList<CloudObject> cloudComponents = new ArrayList<CloudObject>(components.size());
            for (Coder<?> component : components) {
                cloudComponents.add(CloudObjects.asCloudObject(component, sdkComponents));
            }
            Structs.addList((Map<String, Object>)((Object)base), "component_encodings", cloudComponents);
        }
        return base;
    }

    private static List<Coder<?>> getComponents(CloudObject target) {
        List<Map<String, Object>> cloudComponents = Structs.getListOfMaps((Map<String, Object>)((Object)target), "component_encodings", Collections.emptyList());
        ArrayList components = new ArrayList();
        for (Map<String, Object> cloudComponent : cloudComponents) {
            components.add(CloudObjects.coderFromCloudObject(CloudObject.fromSpec(cloudComponent)));
        }
        return components;
    }

    public static CloudObjectTranslator<KvCoder> pair() {
        return new CloudObjectTranslator<KvCoder>(){

            @Override
            public CloudObject toCloudObject(KvCoder target, SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:pair");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_pair_like", true);
                return CloudObjectTranslators.addComponents(result, ImmutableList.of(target.getKeyCoder(), target.getValueCoder()), sdkComponents);
            }

            @Override
            public KvCoder fromCloudObject(CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument(components.size() == 2, "Expecting 2 components, got %s", components.size());
                return KvCoder.of((Coder)((Coder)components.get(0)), (Coder)((Coder)components.get(1)));
            }

            @Override
            public Class<KvCoder> getSupportedClass() {
                return KvCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:pair";
            }
        };
    }

    public static CloudObjectTranslator<IterableCoder> stream() {
        return new CloudObjectTranslator<IterableCoder>(){

            @Override
            public CloudObject toCloudObject(IterableCoder target, SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:stream");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_stream_like", true);
                return CloudObjectTranslators.addComponents(result, Collections.singletonList(target.getElemCoder()), sdkComponents);
            }

            @Override
            public IterableCoder fromCloudObject(CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument(components.size() == 1, "Expecting 1 component, got %s", components.size());
                return IterableCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public Class<? extends IterableCoder> getSupportedClass() {
                return IterableCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:stream";
            }
        };
    }

    static CloudObjectTranslator<LengthPrefixCoder> lengthPrefix() {
        return new CloudObjectTranslator<LengthPrefixCoder>(){

            @Override
            public CloudObject toCloudObject(LengthPrefixCoder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:length_prefix"), Collections.singletonList(target.getValueCoder()), sdkComponents);
            }

            @Override
            public LengthPrefixCoder fromCloudObject(CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument(components.size() == 1, "Expecting 1 component, got %s", components.size());
                return LengthPrefixCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public Class<? extends LengthPrefixCoder> getSupportedClass() {
                return LengthPrefixCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:length_prefix";
            }
        };
    }

    static CloudObjectTranslator<GlobalWindow.Coder> globalWindow() {
        return new CloudObjectTranslator<GlobalWindow.Coder>(){

            @Override
            public CloudObject toCloudObject(GlobalWindow.Coder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:global_window"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public GlobalWindow.Coder fromCloudObject(CloudObject object) {
                return GlobalWindow.Coder.INSTANCE;
            }

            @Override
            public Class<? extends GlobalWindow.Coder> getSupportedClass() {
                return GlobalWindow.Coder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:global_window";
            }
        };
    }

    static CloudObjectTranslator<IntervalWindow.IntervalWindowCoder> intervalWindow() {
        return new CloudObjectTranslator<IntervalWindow.IntervalWindowCoder>(){

            @Override
            public CloudObject toCloudObject(IntervalWindow.IntervalWindowCoder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:interval_window"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public IntervalWindow.IntervalWindowCoder fromCloudObject(CloudObject object) {
                return IntervalWindow.IntervalWindowCoder.of();
            }

            @Override
            public Class<? extends IntervalWindow.IntervalWindowCoder> getSupportedClass() {
                return IntervalWindow.IntervalWindowCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:interval_window";
            }
        };
    }

    static CloudObjectTranslator<WindowedValue.FullWindowedValueCoder> windowedValue() {
        return new CloudObjectTranslator<WindowedValue.FullWindowedValueCoder>(){

            @Override
            public CloudObject toCloudObject(WindowedValue.FullWindowedValueCoder target, SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:windowed_value");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_wrapper", true);
                return CloudObjectTranslators.addComponents(result, ImmutableList.of(target.getValueCoder(), target.getWindowCoder()), sdkComponents);
            }

            @Override
            public WindowedValue.FullWindowedValueCoder fromCloudObject(CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument(components.size() == 2, "Expecting 2 components, got " + components.size());
                Coder window = (Coder)components.get(1);
                return WindowedValue.FullWindowedValueCoder.of((Coder)((Coder)components.get(0)), (Coder)window);
            }

            @Override
            public Class<? extends WindowedValue.FullWindowedValueCoder> getSupportedClass() {
                return WindowedValue.FullWindowedValueCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:windowed_value";
            }
        };
    }

    static CloudObjectTranslator<ByteArrayCoder> bytes() {
        return new CloudObjectTranslator<ByteArrayCoder>(){

            @Override
            public CloudObject toCloudObject(ByteArrayCoder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:bytes"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public ByteArrayCoder fromCloudObject(CloudObject object) {
                return ByteArrayCoder.of();
            }

            @Override
            public Class<? extends ByteArrayCoder> getSupportedClass() {
                return ByteArrayCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return "kind:bytes";
            }
        };
    }

    static CloudObjectTranslator<VarLongCoder> varInt() {
        return new CloudObjectTranslator<VarLongCoder>(){

            @Override
            public CloudObject toCloudObject(VarLongCoder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClass(target.getClass()), Collections.emptyList(), sdkComponents);
            }

            @Override
            public VarLongCoder fromCloudObject(CloudObject object) {
                return VarLongCoder.of();
            }

            @Override
            public Class<? extends VarLongCoder> getSupportedClass() {
                return VarLongCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(VarLongCoder.class).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<Coder> javaSerialized() {
        return new CloudObjectTranslator<Coder>(){

            @Override
            public CloudObject toCloudObject(Coder target, SdkComponents sdkComponents) {
                CloudObject cloudObject = CloudObject.forClass(CustomCoder.class);
                Structs.addString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.TYPE_FIELD, target.getClass().getName());
                Structs.addString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.CODER_FIELD, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target)));
                return cloudObject;
            }

            @Override
            public Coder fromCloudObject(CloudObject cloudObject) {
                String serializedCoder = Structs.getString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.CODER_FIELD);
                String type = Structs.getString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.TYPE_FIELD);
                return (Coder)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)serializedCoder), (String)type);
            }

            @Override
            public Class<? extends CustomCoder> getSupportedClass() {
                return CustomCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(CustomCoder.class).getClassName();
            }
        };
    }

    public static <T extends Coder> CloudObjectTranslator<T> atomic(final Class<T> coderClass) {
        InstanceBuilder.ofType(coderClass).fromFactoryMethod("of").build();
        return new CloudObjectTranslator<T>(){

            @Override
            public CloudObject toCloudObject(T target, SdkComponents sdkComponents) {
                return CloudObject.forClass(coderClass);
            }

            @Override
            public T fromCloudObject(CloudObject cloudObject) {
                return (Coder)InstanceBuilder.ofType((Class)coderClass).fromFactoryMethod("of").build();
            }

            @Override
            public Class<? extends T> getSupportedClass() {
                return coderClass;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(coderClass).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<IterableLikeCoder> iterableLike(final Class<? extends IterableLikeCoder> clazz) {
        return new CloudObjectTranslator<IterableLikeCoder>(){

            @Override
            public CloudObject toCloudObject(IterableLikeCoder target, SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(clazz);
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getElemCoder()), sdkComponents);
            }

            @Override
            public IterableLikeCoder<?, ?> fromCloudObject(CloudObject cloudObject) {
                List elemCoderList = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument(elemCoderList.size() == 1, "Expected 1 component for %s, got %s", (Object)cloudObject.getClassName(), elemCoderList.size());
                return (IterableLikeCoder)InstanceBuilder.ofType((Class)clazz).fromFactoryMethod("of").withArg(Coder.class, (Object)((Coder)elemCoderList.get(0))).build();
            }

            @Override
            public Class<? extends IterableLikeCoder> getSupportedClass() {
                return clazz;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(clazz).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<MapCoder> map() {
        return new CloudObjectTranslator<MapCoder>(){

            @Override
            public CloudObject toCloudObject(MapCoder target, SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(MapCoder.class);
                return CloudObjectTranslators.addComponents(base, ImmutableList.of(target.getKeyCoder(), target.getValueCoder()), sdkComponents);
            }

            @Override
            public MapCoder<?, ?> fromCloudObject(CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument(components.size() == 2, "Expected 2 components for %s, got %s", (Object)MapCoder.class.getSimpleName(), components.size());
                return MapCoder.of((Coder)((Coder)components.get(0)), (Coder)((Coder)components.get(1)));
            }

            @Override
            public Class<? extends MapCoder> getSupportedClass() {
                return MapCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(MapCoder.class).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<NullableCoder> nullable() {
        return new CloudObjectTranslator<NullableCoder>(){

            @Override
            public CloudObject toCloudObject(NullableCoder target, SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(NullableCoder.class);
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getValueCoder()), sdkComponents);
            }

            @Override
            public NullableCoder<?> fromCloudObject(CloudObject cloudObject) {
                List componentList = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument(componentList.size() == 1, "Expected 1 component for %s, got %s", (Object)NullableCoder.class.getSimpleName(), componentList.size());
                return NullableCoder.of((Coder)((Coder)componentList.get(0)));
            }

            @Override
            public Class<? extends NullableCoder> getSupportedClass() {
                return NullableCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(NullableCoder.class).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<UnionCoder> union() {
        return new CloudObjectTranslator<UnionCoder>(){

            @Override
            public CloudObject toCloudObject(UnionCoder target, SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClass(UnionCoder.class), target.getElementCoders(), sdkComponents);
            }

            @Override
            public UnionCoder fromCloudObject(CloudObject cloudObject) {
                List elementCoders = CloudObjectTranslators.getComponents(cloudObject);
                return UnionCoder.of((List)elementCoders);
            }

            @Override
            public Class<? extends UnionCoder> getSupportedClass() {
                return UnionCoder.class;
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(UnionCoder.class).getClassName();
            }
        };
    }

    public static CloudObjectTranslator<CoGbkResult.CoGbkResultCoder> coGroupByKeyResult() {
        return new CloudObjectTranslator<CoGbkResult.CoGbkResultCoder>(){

            @Override
            public CloudObject toCloudObject(CoGbkResult.CoGbkResultCoder target, SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(CoGbkResult.CoGbkResultCoder.class);
                Structs.addObject((Map<String, Object>)((Object)base), "co_gbk_result_schema", (Map<String, Object>)((Object)this.toCloudObject(target.getSchema())));
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getUnionCoder()), sdkComponents);
            }

            private CloudObject toCloudObject(CoGbkResultSchema schema) {
                CloudObject result = CloudObject.forClass(CoGbkResultSchema.class);
                ArrayList<CloudObject> tags = new ArrayList<CloudObject>(schema.getTupleTagList().size());
                for (TupleTag tag : schema.getTupleTagList().getAll()) {
                    CloudObject tagCloudObject = CloudObject.forClass(TupleTag.class);
                    Structs.addString((Map<String, Object>)((Object)tagCloudObject), "value", tag.getId());
                    tags.add(tagCloudObject);
                }
                Structs.addList((Map<String, Object>)((Object)result), "tuple_tags", tags);
                return result;
            }

            @Override
            public CoGbkResult.CoGbkResultCoder fromCloudObject(CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument(components.size() == 1, "Expected 1 component for %s, got %s", (Object)CoGbkResult.CoGbkResultCoder.class.getSimpleName(), components.size());
                Preconditions.checkArgument(components.get(0) instanceof UnionCoder, "Expected only component to be a %s, got %s", (Object)UnionCoder.class.getSimpleName(), (Object)((Coder)components.get(0)).getClass().getName());
                return CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)this.schemaFromCloudObject(CloudObject.fromSpec(Structs.getObject((Map<String, Object>)((Object)cloudObject), "co_gbk_result_schema"))), (UnionCoder)((UnionCoder)components.get(0)));
            }

            @Override
            public Class<? extends CoGbkResult.CoGbkResultCoder> getSupportedClass() {
                return CoGbkResult.CoGbkResultCoder.class;
            }

            private CoGbkResultSchema schemaFromCloudObject(CloudObject cloudObject) {
                ArrayList<TupleTag> tags = new ArrayList<TupleTag>();
                List<Map<String, Object>> serializedTags = Structs.getListOfMaps((Map<String, Object>)((Object)cloudObject), "tuple_tags", Collections.emptyList());
                for (Map<String, Object> serializedTag : serializedTags) {
                    TupleTag tag = new TupleTag(Structs.getString(serializedTag, "value"));
                    tags.add(tag);
                }
                return CoGbkResultSchema.of(tags);
            }

            @Override
            public String cloudObjectClassName() {
                return CloudObject.forClass(CoGbkResult.CoGbkResultCoder.class).getClassName();
            }
        };
    }
}

