/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_google_cloud_dataflow_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.core.construction.ModelCoderRegistrar;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CoderCloudObjectTranslatorRegistrar;
import org.apache.beam.runners.dataflow.util.DefaultCoderCloudObjectTranslatorRegistrar;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;

public class CloudObjects {
    static final Map<Class<? extends Coder>, CloudObjectTranslator<? extends Coder>> CODER_TRANSLATORS = CloudObjects.populateCoderTranslators();
    static final Map<String, CloudObjectTranslator<? extends Coder>> CLOUD_OBJECT_CLASS_NAME_TRANSLATORS = CloudObjects.populateCloudObjectTranslators();

    private CloudObjects() {
    }

    private static Map<Class<? extends Coder>, CloudObjectTranslator<? extends Coder>> populateCoderTranslators() {
        ImmutableMap.Builder<Class<? extends Coder>, CloudObjectTranslator<? extends Coder>> builder = ImmutableMap.builder();
        for (CoderCloudObjectTranslatorRegistrar coderRegistrar : ServiceLoader.load(CoderCloudObjectTranslatorRegistrar.class)) {
            builder.putAll(coderRegistrar.classesToTranslators());
        }
        return builder.build();
    }

    private static Map<String, CloudObjectTranslator<? extends Coder>> populateCloudObjectTranslators() {
        ImmutableMap.Builder<String, CloudObjectTranslator<? extends Coder>> builder = ImmutableMap.builder();
        for (CoderCloudObjectTranslatorRegistrar coderRegistrar : ServiceLoader.load(CoderCloudObjectTranslatorRegistrar.class)) {
            builder.putAll(coderRegistrar.classNamesToTranslators());
        }
        return builder.build();
    }

    public static CloudObject asCloudObject(Coder<?> coder, @Nullable SdkComponents sdkComponents) {
        CloudObject encoding;
        CloudObjectTranslator<? extends Coder> translator = CODER_TRANSLATORS.get(coder.getClass());
        if (translator != null) {
            encoding = translator.toCloudObject(coder, sdkComponents);
        } else {
            CloudObjectTranslator<? extends Coder> customCoderTranslator = CODER_TRANSLATORS.get(CustomCoder.class);
            Preconditions.checkNotNull(customCoderTranslator, "No %s registered for %s, but it is in the %s", (Object)CloudObjectTranslator.class.getSimpleName(), (Object)CustomCoder.class.getSimpleName(), (Object)DefaultCoderCloudObjectTranslatorRegistrar.class.getSimpleName());
            encoding = customCoderTranslator.toCloudObject(coder, sdkComponents);
        }
        if (sdkComponents != null && !ModelCoderRegistrar.isKnownCoder(coder)) {
            try {
                String coderId = sdkComponents.registerCoder(coder);
                Structs.addString((Map<String, Object>)((Object)encoding), "pipeline_proto_coder_id", coderId);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register coder " + coder, e);
            }
        }
        return encoding;
    }

    public static Coder<?> coderFromCloudObject(CloudObject cloudObject) {
        CloudObjectTranslator<? extends Coder> translator = CLOUD_OBJECT_CLASS_NAME_TRANSLATORS.get(cloudObject.getClassName());
        Preconditions.checkArgument(translator != null, "Unknown %s class %s", (Object)Coder.class.getSimpleName(), (Object)cloudObject.getClassName());
        return translator.fromCloudObject(cloudObject);
    }
}

