/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.fnexecution.GrpcContextHeaderAccessorProvider;
import org.apache.beam.runners.fnexecution.ServerFactory;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerInterceptor;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerInterceptors;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.inprocess.InProcessServerBuilder;

public class InProcessServerFactory
extends ServerFactory {
    private static final AtomicInteger serviceNameUniqifier = new AtomicInteger();

    public static InProcessServerFactory create() {
        return new InProcessServerFactory();
    }

    private InProcessServerFactory() {
    }

    @Override
    public Server allocateAddressAndCreate(List<BindableService> services, Endpoints.ApiServiceDescriptor.Builder builder) throws IOException {
        String name = String.format("InProcessServer_%s", serviceNameUniqifier.getAndIncrement());
        builder.setUrl(name);
        InProcessServerBuilder serverBuilder = InProcessServerBuilder.forName((String)name);
        services.stream().forEach(service -> {
            InProcessServerBuilder cfr_ignored_0 = (InProcessServerBuilder)serverBuilder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}));
        });
        return serverBuilder.build().start();
    }

    @Override
    public Server create(List<BindableService> services, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)serviceDescriptor.getUrl());
        services.stream().forEach(service -> {
            InProcessServerBuilder cfr_ignored_0 = (InProcessServerBuilder)builder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}));
        });
        return builder.build().start();
    }
}

