/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerReceiverFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TimerReceiverFactory.class);
    private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>,  @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.TimerSpec> transformAndTimerIdToSpecMap = new HashMap();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataConsumer;
    private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;

    public TimerReceiverFactory(@UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataConsumer, @UnknownKeyFor @NonNull @Initialized Coder windowCoder) {
        for (Map<String, ProcessBundleDescriptors.TimerSpec> transformTimerMap : stageBundleFactory.getProcessBundleDescriptor().getTimerSpecs().values()) {
            for (ProcessBundleDescriptors.TimerSpec timerSpec : transformTimerMap.values()) {
                this.transformAndTimerIdToSpecMap.put((KV<String, String>)KV.of((Object)timerSpec.transformId(), (Object)timerSpec.timerId()), timerSpec);
            }
        }
        this.timerDataConsumer = timerDataConsumer;
        this.windowCoder = windowCoder;
    }

    public <K> @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized Timer<K>> create(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        ProcessBundleDescriptors.TimerSpec timerSpec = this.transformAndTimerIdToSpecMap.get(KV.of((Object)transformId, (Object)timerFamilyId));
        return receivedElement -> {
            Timer timer = (Timer)Preconditions.checkNotNull((Object)receivedElement, (String)"Received null Timer from SDK harness: %s", (Object)receivedElement);
            LOG.debug("Timer received: {}", (Object)timer);
            for (Object window : timer.getWindows()) {
                StateNamespace namespace = StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)((BoundedWindow)window));
                TimerInternals.TimerData timerData = TimerInternals.TimerData.of((String)timer.getDynamicTimerTag(), (String)TimerReceiverFactory.encodeToTimerDataTimerId(timerSpec.transformId(), timerSpec.timerId()), (StateNamespace)namespace, (Instant)(timer.getClearBit() ? BoundedWindow.TIMESTAMP_MAX_VALUE : timer.getFireTimestamp()), (Instant)(timer.getClearBit() ? BoundedWindow.TIMESTAMP_MAX_VALUE : timer.getHoldTimestamp()), (TimeDomain)timerSpec.getTimerSpec().getTimeDomain());
                this.timerDataConsumer.accept(timer, timerData);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized String encodeToTimerDataTimerId(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        return transformId.length() + ":" + transformId + ":" + timerFamilyId;
    }

    public static @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> decodeTimerDataTimerId(@UnknownKeyFor @NonNull @Initialized String timerDataTimerId) {
        int transformIdLengthSplit = timerDataTimerId.indexOf(":");
        if (transformIdLengthSplit <= 0) {
            throw new IllegalArgumentException(String.format("Invalid encoding, expected len(transformId):transformId:timerId as the encoding but received %s", timerDataTimerId));
        }
        int transformIdLength = Integer.parseInt(timerDataTimerId.substring(0, transformIdLengthSplit));
        String transformId = timerDataTimerId.substring(transformIdLengthSplit + 1, transformIdLengthSplit + 1 + transformIdLength);
        String timerFamilyId = timerDataTimerId.substring(transformIdLengthSplit + 1 + transformIdLength + 1);
        return KV.of((Object)transformId, (Object)timerFamilyId);
    }
}

