/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessServerBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.testing.GrpcCleanupRule;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ArtifactRetrievalServiceTest {
    private static final int TEST_BUFFER_SIZE = 1024;
    private ArtifactRetrievalService retrievalService;
    private ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalBlockingStub;
    private Path stagingDir;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public final GrpcCleanupRule grpcCleanup = new GrpcCleanupRule();
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);

    @Before
    public void setUp() throws Exception {
        this.retrievalService = new ArtifactRetrievalService(1024);
        this.grpcCleanup.register(((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)"server").directExecutor()).addService((BindableService)this.retrievalService)).build().start());
        ManagedChannel channel = this.grpcCleanup.register(InProcessChannelBuilder.forName((String)"server").build());
        this.retrievalBlockingStub = ArtifactRetrievalServiceGrpc.newBlockingStub((Channel)channel);
        this.stagingDir = this.tempFolder.newFolder("staging").toPath();
    }

    private void stageFiles(Map<String, String> files) throws IOException {
        for (Map.Entry<String, String> entry : files.entrySet()) {
            Files.write(Paths.get(this.stagingDir.toString(), entry.getKey()), entry.getValue().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private RunnerApi.ArtifactInformation fileArtifact(Path path) {
        return this.fileArtifact(path, "");
    }

    private RunnerApi.ArtifactInformation fileArtifact(Path path, String role) {
        return RunnerApi.ArtifactInformation.newBuilder().setTypeUrn("beam:artifact:type:file:v1").setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(path.toString()).build().toByteString()).setRoleUrn(role).build();
    }

    @Test
    public void testResolveArtifacts() throws IOException {
        RunnerApi.ArtifactInformation artifact = this.fileArtifact(Paths.get("somePath", new String[0]));
        ArtifactApi.ResolveArtifactsResponse resolved = this.retrievalBlockingStub.resolveArtifacts(ArtifactApi.ResolveArtifactsRequest.newBuilder().addArtifacts(artifact).build());
        Assert.assertEquals((long)1L, (long)resolved.getReplacementsCount());
        Assert.assertEquals((Object)artifact, (Object)resolved.getReplacements(0));
    }

    private String getArtifact(RunnerApi.ArtifactInformation artifact) {
        ByteString all = ByteString.EMPTY;
        Iterator response = this.retrievalBlockingStub.getArtifact(ArtifactApi.GetArtifactRequest.newBuilder().setArtifact(artifact).build());
        while (response.hasNext()) {
            all = all.concat(((ArtifactApi.GetArtifactResponse)response.next()).getData());
        }
        return all.toStringUtf8();
    }

    @Test
    public void testRetrieveArtifacts() throws IOException, InterruptedException {
        ImmutableMap artifacts = ImmutableMap.of((Object)"a.txt", (Object)"a", (Object)"b.txt", (Object)"bbb", (Object)"c.txt", (Object)Strings.repeat((String)"cxy", (int)768));
        this.stageFiles((Map<String, String>)artifacts);
        for (Map.Entry artifact : artifacts.entrySet()) {
            Assert.assertEquals(artifact.getValue(), (Object)this.getArtifact(this.fileArtifact(Paths.get(this.stagingDir.toString(), (String)artifact.getKey()))));
        }
    }
}

