/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.jobmanagement.v1.ArtifactStagingServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.artifact.ArtifactStagingService;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessServerBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.testing.GrpcCleanupRule;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ArtifactStagingServiceTest {
    private static final int TEST_BUFFER_SIZE = 1024;
    private ArtifactStagingService stagingService;
    private ArtifactRetrievalService retrievalService;
    private ArtifactStagingServiceGrpc.ArtifactStagingServiceStub stagingStub;
    private ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalBlockingStub;
    private Path stagingDir;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public final GrpcCleanupRule grpcCleanup = new GrpcCleanupRule();
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);

    @Before
    public void setUp() throws Exception {
        this.stagingDir = this.tempFolder.newFolder("staging").toPath();
        this.stagingService = new ArtifactStagingService(ArtifactStagingService.beamFilesystemArtifactDestinationProvider((String)this.stagingDir.toString()));
        this.retrievalService = new ArtifactRetrievalService(1024);
        this.grpcCleanup.register(((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)"server").directExecutor()).addService((BindableService)this.stagingService)).addService((BindableService)this.retrievalService)).build().start());
        ManagedChannel channel = this.grpcCleanup.register(InProcessChannelBuilder.forName((String)"server").build());
        this.stagingStub = ArtifactStagingServiceGrpc.newStub((Channel)channel);
        this.retrievalBlockingStub = ArtifactRetrievalServiceGrpc.newBlockingStub((Channel)channel);
    }

    private String getArtifact(RunnerApi.ArtifactInformation artifact) {
        ByteString all = ByteString.EMPTY;
        Iterator response = this.retrievalBlockingStub.getArtifact(ArtifactApi.GetArtifactRequest.newBuilder().setArtifact(artifact).build());
        while (response.hasNext()) {
            all = all.concat(((ArtifactApi.GetArtifactResponse)response.next()).getData());
        }
        return all.toStringUtf8();
    }

    @Test
    public void testStageArtifacts() throws InterruptedException, ExecutionException {
        ImmutableList contentsList = ImmutableList.of((Object)"a", (Object)"bb", (Object)Strings.repeat((String)"xyz", (int)768));
        this.stagingService.registerJob("stagingToken", (Map)ImmutableMap.of((Object)"env1", (Object)Lists.transform((List)contentsList, FakeArtifactRetrievalService::resolvedArtifact), (Object)"env2", (Object)Lists.transform((List)contentsList, FakeArtifactRetrievalService::unresolvedArtifact)));
        ArtifactStagingService.offer((ArtifactRetrievalService)new FakeArtifactRetrievalService(), (ArtifactStagingServiceGrpc.ArtifactStagingServiceStub)this.stagingStub, (String)"stagingToken");
        Map staged = this.stagingService.getStagedArtifacts("stagingToken");
        Assert.assertEquals((long)2L, (long)staged.size());
        this.checkArtifacts((Collection<String>)contentsList, (List)staged.get("env1"));
        this.checkArtifacts((Collection<String>)contentsList, (List)staged.get("env2"));
    }

    private void checkArtifacts(Collection<String> expectedContents, List<RunnerApi.ArtifactInformation> staged) {
        Assert.assertEquals(expectedContents, (Object)Lists.transform(staged, RunnerApi.ArtifactInformation::getRoleUrn));
        Assert.assertEquals(expectedContents, (Object)Lists.transform(staged, this::getArtifact));
    }

    private static class FakeArtifactRetrievalService
    extends ArtifactRetrievalService {
        private FakeArtifactRetrievalService() {
        }

        public void resolveArtifacts(ArtifactApi.ResolveArtifactsRequest request, StreamObserver<ArtifactApi.ResolveArtifactsResponse> responseObserver) {
            ArtifactApi.ResolveArtifactsResponse.Builder response = ArtifactApi.ResolveArtifactsResponse.newBuilder();
            for (RunnerApi.ArtifactInformation artifact : request.getArtifactsList()) {
                if (artifact.getTypeUrn().equals("resolved")) {
                    response.addReplacements(artifact);
                    continue;
                }
                if (artifact.getTypeUrn().equals("unresolved")) {
                    response.addReplacements(artifact.toBuilder().setTypeUrn("resolved").build());
                    continue;
                }
                throw new UnsupportedOperationException(artifact.getTypeUrn());
            }
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }

        public void getArtifact(ArtifactApi.GetArtifactRequest request, StreamObserver<ArtifactApi.GetArtifactResponse> responseObserver) {
            if (!request.getArtifact().getTypeUrn().equals("resolved")) {
                throw new UnsupportedOperationException(request.getArtifact().getTypeUrn());
            }
            ByteString data = request.getArtifact().getTypePayload();
            responseObserver.onNext((Object)ArtifactApi.GetArtifactResponse.newBuilder().setData(data.substring(0, 1)).build());
            responseObserver.onNext((Object)ArtifactApi.GetArtifactResponse.newBuilder().setData(data.substring(1)).build());
            responseObserver.onCompleted();
        }

        public static RunnerApi.ArtifactInformation resolvedArtifact(String contents) {
            return RunnerApi.ArtifactInformation.newBuilder().setTypeUrn("resolved").setTypePayload(ByteString.copyFromUtf8((String)contents)).setRoleUrn(contents).build();
        }

        public static RunnerApi.ArtifactInformation unresolvedArtifact(String contents) {
            return RunnerApi.ArtifactInformation.newBuilder().setTypeUrn("unresolved").setTypePayload(ByteString.copyFromUtf8((String)contents)).setRoleUrn(contents).build();
        }
    }
}

