/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.testing.NeedsDocker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={NeedsDocker.class})
@RunWith(value=JUnit4.class)
public class DockerCommandTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void helloWorld() throws Exception {
        DockerCommand docker = DockerCommand.getDefault();
        String container = docker.runImage("hello-world", (List)ImmutableList.of(), (List)ImmutableList.of());
        System.out.printf("Started container: %s%n", container);
    }

    @Test
    public void killContainer() throws Exception {
        DockerCommand docker = DockerCommand.getDefault();
        String container = docker.runImage("debian", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"/bin/bash", (Object)"-c", (Object)"sleep 60"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        MatcherAssert.assertThat((String)"Container should be running.", (Object)docker.isContainerRunning(container), (Matcher)Matchers.is((Object)true));
        docker.killContainer(container);
        long elapsedSec = stopwatch.elapsed(TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Container termination should complete before image self-exits", (Object)elapsedSec, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(60L))));
        MatcherAssert.assertThat((String)"Container should be terminated.", (Object)docker.isContainerRunning(container), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void capturesErrorOutput() throws Exception {
        DockerCommand docker = DockerCommand.getDefault();
        this.thrown.expect(Matchers.instanceOf(IOException.class));
        this.thrown.expectMessage(Matchers.containsString((String)"Error response from daemon"));
        String badImageName = "this-image-should-hopefully-never-exist";
        String container = docker.runImage(badImageName, (List)ImmutableList.of(), (List)ImmutableList.of());
        docker.killContainer(container);
        Assert.fail((String)String.format("Container creation for %s should have failed", badImageName));
    }
}

