/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProcessManagerTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);

    @Test
    public void testRunSimpleCommand() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        processManager.startProcess("1", "bash", Collections.emptyList());
        processManager.stopProcess("1");
        processManager.startProcess("2", "bash", Arrays.asList("-c", "ls"));
        processManager.stopProcess("2");
        processManager.startProcess("1", "bash", Arrays.asList("-c", "ls", "-l", "-a"));
        processManager.stopProcess("1");
    }

    @Test
    public void testRunInvalidExecutable() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        try {
            processManager.startProcess("1", "asfasfls", Collections.emptyList());
            Assert.fail();
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot run program \"asfasfls\""));
        }
    }

    @Test
    public void testDuplicateId() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        processManager.startProcess("1", "bash", Arrays.asList("-c", "ls"));
        try {
            processManager.startProcess("1", "bash", Arrays.asList("-c", "ls"));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            processManager.stopProcess("1");
        }
    }

    @Test
    public void testLivenessCheck() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "sleep", "1000"));
        process.isAliveOrThrow();
        processManager.stopProcess("1");
        try {
            process.isAliveOrThrow();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEnvironmentVariables() throws IOException, InterruptedException {
        ProcessManager processManager = ProcessManager.create();
        ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "sleep $PARAM"), Collections.singletonMap("PARAM", "-h"));
        for (int i = 0; i < 10 && process.getUnderlyingProcess().isAlive(); ++i) {
            Thread.sleep(100L);
        }
        MatcherAssert.assertThat((Object)process.getUnderlyingProcess().exitValue(), (Matcher)Matchers.is((Object)1));
        processManager.stopProcess("1");
    }

    @Test
    public void testRedirectOutput() throws IOException, InterruptedException {
        File outputFile = File.createTempFile("beam-redirect-output-", "");
        outputFile.deleteOnExit();
        ProcessManager processManager = ProcessManager.create();
        ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "echo 'testing123'"), Collections.emptyMap(), outputFile);
        for (int i = 0; i < 10 && process.getUnderlyingProcess().isAlive(); ++i) {
            Thread.sleep(100L);
        }
        processManager.stopProcess("1");
        byte[] output = Files.readAllBytes(outputFile.toPath());
        Assert.assertNotNull((Object)output);
        String outputStr = new String(output, StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)outputStr, (Matcher)Matchers.containsString((String)"testing123"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritIO() throws IOException, InterruptedException {
        PrintStream oldOut = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(baos);
        try {
            System.setOut(newOut);
            ProcessManager processManager = ProcessManager.create();
            ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "echo 'testing123' 1>&2;"), Collections.emptyMap(), ProcessManager.INHERIT_IO_FILE);
            for (int i = 0; i < 10 && process.getUnderlyingProcess().isAlive(); ++i) {
                Thread.sleep(100L);
            }
            processManager.stopProcess("1");
        }
        finally {
            System.setOut(oldOut);
        }
        Assert.assertFalse((boolean)ProcessManager.INHERIT_IO_FILE.exists());
    }

    @Test
    public void testShutdownHook() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        Assert.assertNull((Object)ProcessManager.shutdownHook);
        processManager.startProcess("1", "bash", Arrays.asList("-c", "echo 'testing123'"), Collections.emptyMap());
        Assert.assertNotNull((Object)ProcessManager.shutdownHook);
        Assert.assertTrue((boolean)Runtime.getRuntime().removeShutdownHook(ProcessManager.shutdownHook));
        Runtime.getRuntime().addShutdownHook(ProcessManager.shutdownHook);
        processManager.startProcess("2", "bash", Arrays.asList("-c", "echo 'testing123'"), Collections.emptyMap());
        processManager.stopProcess("1");
        Assert.assertNotNull((Object)ProcessManager.shutdownHook);
        processManager.stopProcess("2");
        Assert.assertNull((Object)ProcessManager.shutdownHook);
    }
}

