/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.provisioning;

import org.apache.beam.model.fnexecution.v1.ProvisionApi;
import org.apache.beam.model.fnexecution.v1.ProvisionServiceGrpc;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.channel.AddHarnessIdInterceptor;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.GrpcContextHeaderAccessorProvider;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.server.HeaderAccessor;
import org.apache.beam.sdk.fn.server.InProcessServerFactory;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ListValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.NullValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Value;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ClientInterceptor;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessChannelBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StaticGrpcProvisionServiceTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);

    @Test
    public void returnsProvisionInfo() throws Exception {
        Struct options = Struct.newBuilder().putFields("foo", Value.newBuilder().setBoolValue(true).build()).putFields("bar", Value.newBuilder().setNumberValue(2.5).build()).putFields("baz", Value.newBuilder().setListValue(ListValue.newBuilder().addValues(Value.newBuilder().setStructValue(Struct.newBuilder().putFields("spam", Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build()).build()).build();
        ProvisionApi.ProvisionInfo info = ProvisionApi.ProvisionInfo.newBuilder().setPipelineOptions(options).build();
        GrpcFnServer server = GrpcFnServer.allocatePortAndCreateFor((FnService)StaticGrpcProvisionService.create((ProvisionApi.ProvisionInfo)info, (HeaderAccessor)GrpcContextHeaderAccessorProvider.getHeaderAccessor()), (ServerFactory)InProcessServerFactory.create());
        ProvisionServiceGrpc.ProvisionServiceBlockingStub stub = ProvisionServiceGrpc.newBlockingStub((Channel)((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)server.getApiServiceDescriptor().getUrl()).intercept(new ClientInterceptor[]{AddHarnessIdInterceptor.create((String)"test_worker")})).build());
        ProvisionApi.GetProvisionInfoResponse provisionResponse = stub.getProvisionInfo(ProvisionApi.GetProvisionInfoRequest.getDefaultInstance());
        MatcherAssert.assertThat((Object)provisionResponse.getInfo(), (Matcher)Matchers.equalTo((Object)info));
    }
}

