/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.fnexecution.wire.ByteStringCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteStringCoderTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);
    private static final ByteStringCoder TEST_CODER = ByteStringCoder.of();
    private static final List<String> TEST_STRING_VALUES = Arrays.asList("", "a", "13", "hello", "a longer string with spaces and all that", "a string with a \n newline", "???????????????");
    private static final ImmutableList<ByteString> TEST_VALUES;
    private static final List<String> TEST_ENCODINGS;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeEqualInAllContexts() throws Exception {
        for (ByteString value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual((Coder)TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64((Coder)TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testCoderDeterministic() throws Throwable {
        TEST_CODER.verifyDeterministic();
    }

    @Test
    public void testConsistentWithEquals() {
        Assert.assertTrue((boolean)TEST_CODER.consistentWithEquals());
    }

    @Test
    public void testEncodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null ByteString");
        CoderUtils.encodeToBase64((Coder)TEST_CODER, null);
    }

    @Test
    public void testNestedCoding() throws Throwable {
        ListCoder listCoder = ListCoder.of((Coder)TEST_CODER);
        CoderProperties.coderDecodeEncodeContentsEqual((Coder)listCoder, TEST_VALUES);
        CoderProperties.coderDecodeEncodeContentsInSameOrder((Coder)listCoder, TEST_VALUES);
    }

    @Test
    public void testEncodedElementByteSize() throws Throwable {
        for (ByteString value : TEST_VALUES) {
            byte[] encoded = CoderUtils.encodeToByteArray((Coder)TEST_CODER, (Object)value, (Coder.Context)Coder.Context.NESTED);
            Assert.assertEquals((long)encoded.length, (long)TEST_CODER.getEncodedElementByteSize(value));
        }
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        MatcherAssert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(ByteString.class)));
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : TEST_STRING_VALUES) {
            builder.add((Object)ByteString.copyFromUtf8((String)s));
        }
        TEST_VALUES = builder.build();
        TEST_ENCODINGS = Arrays.asList("", "YQ", "MTM", "aGVsbG8", "YSBsb25nZXIgc3RyaW5nIHdpdGggc3BhY2VzIGFuZCBhbGwgdGhhdA", "YSBzdHJpbmcgd2l0aCBhIAogbmV3bGluZQ", "Pz8_Pz8_Pz8_Pz8_Pz8_");
    }
}

