/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateBackedIterable;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.fnexecution.wire.AutoValue_CommonCoderTest_CommonCoder;
import org.apache.beam.runners.fnexecution.wire.AutoValue_CommonCoderTest_CommonCoderTestSpec;
import org.apache.beam.runners.fnexecution.wire.AutoValue_CommonCoderTest_OneCoderTestSpec;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.sdk.util.construction.CoderTranslator;
import org.apache.beam.sdk.util.construction.ModelCoderRegistrar;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharStreams;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CommonCoderTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);
    private static final String STANDARD_CODERS_YAML_PATH = "/org/apache/beam/model/fnexecution/v1/standard_coders.yaml";
    private static final Map<String, Class<?>> coders = ImmutableMap.builder().put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BYTES), ByteCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BOOL), BooleanCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STRING_UTF8), StringUtf8Coder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.KV), KvCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.VARINT), VarLongCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.INTERVAL_WINDOW), IntervalWindow.IntervalWindowCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ITERABLE), IterableCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.TIMER), Timer.Coder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.GLOBAL_WINDOW), GlobalWindow.Coder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.DOUBLE), DoubleCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE), WindowedValue.FullWindowedValueCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE), WindowedValue.ParamWindowedValueCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ROW), RowCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.SHARDED_KEY), ShardedKey.Coder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.CUSTOM_WINDOW), TimestampPrefixingWindowCoder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STATE_BACKED_ITERABLE), StateBackedIterable.Coder.class).put((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.NULLABLE), NullableCoder.class).build();
    @Parameterized.Parameter(value=0)
    public OneCoderTestSpec testSpec;
    @Parameterized.Parameter(value=1)
    public String ignoredTestName;

    private static List<OneCoderTestSpec> loadStandardCodersSuite() throws IOException {
        InputStream stream = CommonCoderTest.class.getResourceAsStream(STANDARD_CODERS_YAML_PATH);
        if (stream == null) {
            Assert.fail((String)"Could not load standard coder specs as resource:/org/apache/beam/model/fnexecution/v1/standard_coders.yaml");
        }
        String specString = CharStreams.toString((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
        Iterable specs = Splitter.on((String)"\n---\n").split((CharSequence)specString);
        ArrayList<OneCoderTestSpec> ret = new ArrayList<OneCoderTestSpec>();
        for (String spec : specs) {
            CommonCoderTestSpec coderTestSpec = CommonCoderTest.parseSpec(spec);
            CommonCoder coder = coderTestSpec.getCoder();
            for (Map.Entry<String, Object> oneTestSpec : coderTestSpec.getExamples().entrySet()) {
                byte[] serialized = oneTestSpec.getKey().getBytes(StandardCharsets.ISO_8859_1);
                Object value = oneTestSpec.getValue();
                if (coderTestSpec.getNested() == null) {
                    ret.add(OneCoderTestSpec.create(coder, true, serialized, value));
                    ret.add(OneCoderTestSpec.create(coder, false, serialized, value));
                    continue;
                }
                ret.add(OneCoderTestSpec.create(coder, coderTestSpec.getNested(), serialized, value));
            }
        }
        return ImmutableList.copyOf(ret);
    }

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> data() throws IOException {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (OneCoderTestSpec test : CommonCoderTest.loadStandardCodersSuite()) {
            String testname = MoreObjects.toStringHelper(OneCoderTestSpec.class).add("coder", (Object)test.getCoder()).add("nested", test.getNested()).add("serialized", (Object)test.getSerialized()).toString();
            ret.add((Object)new Object[]{test, testname});
        }
        return ret.build();
    }

    private static CommonCoderTestSpec parseSpec(String spec) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CommonCoderTestSpec)mapper.readValue(spec, CommonCoderTestSpec.class);
    }

    private static void assertCoderIsKnown(CommonCoder coder) {
        MatcherAssert.assertThat((String)"not a known coder", coders.keySet(), (Matcher)Matchers.hasItem((Object)coder.getUrn()));
        for (CommonCoder component : coder.getComponents()) {
            CommonCoderTest.assertCoderIsKnown(component);
        }
    }

    private static Object convertValue(Object value, CommonCoder coderSpec, Coder coder) {
        String s = coderSpec.getUrn();
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BYTES))) {
            return ((String)value).getBytes(StandardCharsets.ISO_8859_1);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BOOL))) {
            return value;
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STRING_UTF8))) {
            return value;
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.KV))) {
            Coder keyCoder = ((KvCoder)coder).getKeyCoder();
            Coder valueCoder = ((KvCoder)coder).getValueCoder();
            Map kvMap = (Map)value;
            Object k = CommonCoderTest.convertValue(kvMap.get("key"), coderSpec.getComponents().get(0), keyCoder);
            Object v = CommonCoderTest.convertValue(kvMap.get("value"), coderSpec.getComponents().get(1), valueCoder);
            return KV.of((Object)k, (Object)v);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.VARINT))) {
            return ((Number)value).longValue();
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.TIMER))) {
            Map kvMap = (Map)value;
            Coder keyCoder = ((Timer.Coder)coder).getValueCoder();
            Coder windowCoder = ((Timer.Coder)coder).getWindowCoder();
            ArrayList<BoundedWindow> windows = new ArrayList<BoundedWindow>();
            for (Object window : (List)kvMap.get("windows")) {
                windows.add((BoundedWindow)CommonCoderTest.convertValue(window, coderSpec.getComponents().get(1), windowCoder));
            }
            if (((Boolean)kvMap.get("clearBit")).booleanValue()) {
                return Timer.cleared((Object)CommonCoderTest.convertValue(kvMap.get("userKey"), coderSpec.getComponents().get(0), keyCoder), (String)((String)kvMap.get("dynamicTimerTag")), windows);
            }
            Map paneInfoMap = (Map)kvMap.get("pane");
            PaneInfo paneInfo = PaneInfo.createPane((boolean)((Boolean)paneInfoMap.get("is_first")), (boolean)((Boolean)paneInfoMap.get("is_last")), (PaneInfo.Timing)PaneInfo.Timing.valueOf((String)((String)paneInfoMap.get("timing"))), (long)((Integer)paneInfoMap.get("index")).intValue(), (long)((Integer)paneInfoMap.get("on_time_index")).intValue());
            return Timer.of((Object)CommonCoderTest.convertValue(kvMap.get("userKey"), coderSpec.getComponents().get(0), keyCoder), (String)((String)kvMap.get("dynamicTimerTag")), windows, (Instant)new Instant(((Number)kvMap.get("fireTimestamp")).longValue()), (Instant)new Instant(((Number)kvMap.get("holdTimestamp")).longValue()), (PaneInfo)paneInfo);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.INTERVAL_WINDOW))) {
            Map kvMap = (Map)value;
            Instant end = new Instant(((Number)kvMap.get("end")).longValue());
            Duration span = Duration.millis((long)((Number)kvMap.get("span")).longValue());
            return new IntervalWindow(end.minus((ReadableDuration)span), (ReadableDuration)span);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ITERABLE)) || s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STATE_BACKED_ITERABLE))) {
            Coder elementCoder = ((IterableLikeCoder)coder).getElemCoder();
            List elements = (List)value;
            ArrayList<Object> convertedElements = new ArrayList<Object>();
            for (Object element : elements) {
                convertedElements.add(CommonCoderTest.convertValue(element, coderSpec.getComponents().get(0), elementCoder));
            }
            return convertedElements;
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.GLOBAL_WINDOW))) {
            return GlobalWindow.INSTANCE;
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE)) || s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE))) {
            Map kvMap = (Map)value;
            Coder valueCoder = ((WindowedValue.FullWindowedValueCoder)coder).getValueCoder();
            Coder windowCoder = ((WindowedValue.FullWindowedValueCoder)coder).getWindowCoder();
            Object windowValue = CommonCoderTest.convertValue(kvMap.get("value"), coderSpec.getComponents().get(0), valueCoder);
            Instant timestamp = new Instant(((Number)kvMap.get("timestamp")).longValue());
            ArrayList<BoundedWindow> windows = new ArrayList<BoundedWindow>();
            for (Object window : (List)kvMap.get("windows")) {
                windows.add((BoundedWindow)CommonCoderTest.convertValue(window, coderSpec.getComponents().get(1), windowCoder));
            }
            Map paneInfoMap = (Map)kvMap.get("pane");
            PaneInfo paneInfo = PaneInfo.createPane((boolean)((Boolean)paneInfoMap.get("is_first")), (boolean)((Boolean)paneInfoMap.get("is_last")), (PaneInfo.Timing)PaneInfo.Timing.valueOf((String)((String)paneInfoMap.get("timing"))), (long)((Integer)paneInfoMap.get("index")).intValue(), (long)((Integer)paneInfoMap.get("on_time_index")).intValue());
            return WindowedValue.of((Object)windowValue, (Instant)timestamp, windows, (PaneInfo)paneInfo);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.DOUBLE))) {
            return Double.parseDouble((String)value);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ROW))) {
            Schema schema;
            try {
                schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)SchemaApi.Schema.parseFrom((byte[])coderSpec.getPayload()));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failed to parse schema payload for row coder", e);
            }
            return CommonCoderTest.parseField(value, Schema.FieldType.row((Schema)schema));
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.SHARDED_KEY))) {
            Map kvMap = (Map)value;
            Coder keyCoder = ((ShardedKey.Coder)coder).getKeyCoder();
            byte[] shardId = ((String)kvMap.get("shardId")).getBytes(StandardCharsets.ISO_8859_1);
            return ShardedKey.of((Object)CommonCoderTest.convertValue(kvMap.get("key"), coderSpec.getComponents().get(0), keyCoder), (byte[])shardId);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.CUSTOM_WINDOW))) {
            Map kvMap = (Map)value;
            Coder windowCoder = ((TimestampPrefixingWindowCoder)coder).getWindowCoder();
            return CommonCoderTest.convertValue(kvMap.get("window"), coderSpec.getComponents().get(0), windowCoder);
        }
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.NULLABLE))) {
            if (coderSpec.getComponents().size() == 1 && coderSpec.getComponents().get(0).getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BYTES))) {
                if (value == null) {
                    return null;
                }
                return ((String)value).getBytes(StandardCharsets.ISO_8859_1);
            }
            throw new IllegalStateException("Unknown or missing nested coder for nullable coder");
        }
        throw new IllegalStateException("Unknown coder URN: " + coderSpec.getUrn());
    }

    private static Object parseField(Object value, Schema.FieldType fieldType) {
        if (value == null) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case INT16: {
                return ((Number)value).shortValue();
            }
            case INT32: {
                return ((Number)value).intValue();
            }
            case INT64: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            case DOUBLE: {
                return Double.parseDouble((String)value);
            }
            case STRING: {
                return (String)value;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case DATETIME: {
                return new Instant((Long)value + Long.MIN_VALUE);
            }
            case DECIMAL: {
                return new BigDecimal((String)value);
            }
            case BYTES: {
                return ((String)value).getBytes(StandardCharsets.ISO_8859_1);
            }
            case ARRAY: {
                return ((List)value).stream().map(element -> CommonCoderTest.parseField(element, fieldType.getCollectionElementType())).collect(ImmutableList.toImmutableList());
            }
            case MAP: {
                HashMap kvMap = new HashMap();
                ((Map)value).entrySet().stream().forEach(entry -> kvMap.put(CommonCoderTest.parseField(entry.getKey(), fieldType.getMapKeyType()), CommonCoderTest.parseField(entry.getValue(), fieldType.getMapValueType())));
                return kvMap;
            }
            case ROW: {
                HashMap rowMap = new HashMap((Map)value);
                Schema schema = fieldType.getRowSchema();
                Row.Builder row = Row.withSchema((Schema)schema);
                for (Schema.Field field : schema.getFields()) {
                    Object element2 = rowMap.remove(field.getName());
                    if (element2 != null) {
                        element2 = CommonCoderTest.parseField(element2, field.getType());
                    }
                    row.addValue(element2);
                }
                if (!rowMap.isEmpty()) {
                    throw new IllegalArgumentException("Value contains keys that are not in the schema: " + rowMap.keySet());
                }
                return row.build();
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                return logicalType.toInputType(CommonCoderTest.parseField(value, fieldType.getLogicalType().getBaseType()));
            }
        }
        throw new IllegalArgumentException("Unsupported type name: " + fieldType.getTypeName());
    }

    private static Coder<?> instantiateCoder(final CommonCoder coder) {
        ArrayList components = new ArrayList();
        for (CommonCoder innerCoder : coder.getComponents()) {
            components.add(CommonCoderTest.instantiateCoder(innerCoder));
        }
        if (coder.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STATE_BACKED_ITERABLE))) {
            BeamFnStateClient stateClient = new BeamFnStateClient(){

                public CompletableFuture<BeamFnApi.StateResponse> handle(BeamFnApi.StateRequest.Builder requestBuilder) {
                    Preconditions.checkState((boolean)requestBuilder.hasGet());
                    Preconditions.checkState((boolean)requestBuilder.hasStateKey());
                    Preconditions.checkState((boolean)requestBuilder.getStateKey().hasRunner());
                    BeamFnApi.StateResponse.Builder rval = BeamFnApi.StateResponse.newBuilder();
                    rval.setId(requestBuilder.getId());
                    rval.setGet(BeamFnApi.StateGetResponse.newBuilder().setData(coder.getState().getOrDefault(requestBuilder.getStateKey().getRunner().getKey(), ByteString.EMPTY)));
                    return CompletableFuture.completedFuture(rval.build());
                }
            };
            return new StateBackedIterable.Coder(() -> Caches.noop(), stateClient, () -> "instructionId", (Coder)Iterables.getOnlyElement(components));
        }
        Class coderType = (Class)ImmutableBiMap.copyOf((Map)new ModelCoderRegistrar().getCoderURNs()).inverse().get((Object)coder.getUrn());
        Preconditions.checkNotNull((Object)coderType, (Object)("Unknown coder URN: " + coder.getUrn()));
        CoderTranslator translator = (CoderTranslator)new ModelCoderRegistrar().getCoderTranslators().get(coderType);
        Preconditions.checkNotNull((Object)translator, (Object)("No translator found for common coder class: " + coderType.getSimpleName()));
        return translator.fromComponents(components, coder.getPayload(), new CoderTranslation.TranslationContext(){});
    }

    @Test
    public void executeSingleTest() throws IOException {
        CommonCoderTest.assertCoderIsKnown(this.testSpec.getCoder());
        Coder<?> coder = CommonCoderTest.instantiateCoder(this.testSpec.getCoder());
        Object testValue = CommonCoderTest.convertValue(this.testSpec.getValue(), this.testSpec.getCoder(), coder);
        Coder.Context context = this.testSpec.getNested() ? Coder.Context.NESTED : Coder.Context.OUTER;
        byte[] encoded = CoderUtils.encodeToByteArray(coder, (Object)testValue, (Coder.Context)context);
        Object decodedValue = CoderUtils.decodeFromByteArray(coder, (byte[])this.testSpec.getSerialized(), (Coder.Context)context);
        if (!this.testSpec.getCoder().getNonDeterministic().booleanValue()) {
            MatcherAssert.assertThat((String)this.testSpec.toString(), (Object)encoded, (Matcher)Matchers.equalTo((Object)this.testSpec.getSerialized()));
        }
        this.verifyDecodedValue(this.testSpec.getCoder(), decodedValue, testValue);
    }

    private void verifyDecodedValue(CommonCoder coder, Object expectedValue, Object actualValue) {
        String s = coder.getUrn();
        if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BYTES))) {
            MatcherAssert.assertThat((Object)expectedValue, (Matcher)Matchers.equalTo((Object)actualValue));
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BOOL))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STRING_UTF8))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.KV))) {
            MatcherAssert.assertThat((Object)actualValue, (Matcher)Matchers.instanceOf(KV.class));
            this.verifyDecodedValue(coder.getComponents().get(0), ((KV)expectedValue).getKey(), ((KV)actualValue).getKey());
            this.verifyDecodedValue(coder.getComponents().get(0), ((KV)expectedValue).getValue(), ((KV)actualValue).getValue());
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.VARINT))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.INTERVAL_WINDOW))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ITERABLE)) || s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STATE_BACKED_ITERABLE))) {
            MatcherAssert.assertThat((Object)actualValue, (Matcher)Matchers.instanceOf(Iterable.class));
            CommonCoder componentCoder = coder.getComponents().get(0);
            Iterator expectedValueIterator = ((Iterable)expectedValue).iterator();
            for (Object value : (Iterable)actualValue) {
                this.verifyDecodedValue(componentCoder, expectedValueIterator.next(), value);
            }
            Assert.assertFalse((boolean)expectedValueIterator.hasNext());
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.TIMER))) {
            Assert.assertEquals((Object)((Timer)expectedValue), (Object)((Timer)actualValue));
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.GLOBAL_WINDOW))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.DOUBLE))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ROW))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.SHARDED_KEY))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.CUSTOM_WINDOW))) {
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.NULLABLE))) {
            MatcherAssert.assertThat((Object)expectedValue, (Matcher)Matchers.equalTo((Object)actualValue));
        } else {
            throw new IllegalStateException("Unknown coder URN: " + coder.getUrn());
        }
    }

    private static <T> String jsonByteString(Coder<T> coder, T value, Coder.Context context) throws CoderException {
        byte[] bytes = CoderUtils.encodeToByteArray(coder, value, (Coder.Context)context);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        try {
            return mapper.writeValueAsString((Object)new String(bytes, StandardCharsets.ISO_8859_1));
        }
        catch (JsonProcessingException e) {
            throw new CoderException(String.format("Unable to encode %s with coder %s", value, coder), (Throwable)e);
        }
    }

    @AutoValue
    static abstract class OneCoderTestSpec {
        OneCoderTestSpec() {
        }

        abstract CommonCoder getCoder();

        abstract boolean getNested();

        abstract byte[] getSerialized();

        abstract @Nullable Object getValue();

        static OneCoderTestSpec create(CommonCoder coder, boolean nested, byte[] serialized, Object value) {
            return new AutoValue_CommonCoderTest_OneCoderTestSpec(coder, nested, serialized, value);
        }
    }

    @AutoValue
    static abstract class CommonCoderTestSpec {
        CommonCoderTestSpec() {
        }

        abstract CommonCoder getCoder();

        abstract @Nullable Boolean getNested();

        abstract Map<String, Object> getExamples();

        @JsonCreator
        static CommonCoderTestSpec create(@JsonProperty(value="coder") CommonCoder coder, @JsonProperty(value="nested") @Nullable Boolean nested, @JsonProperty(value="examples") Map<String, Object> examples) {
            return new AutoValue_CommonCoderTest_CommonCoderTestSpec(coder, nested, examples);
        }
    }

    @AutoValue
    static abstract class CommonCoder {
        CommonCoder() {
        }

        abstract String getUrn();

        abstract List<CommonCoder> getComponents();

        abstract byte[] getPayload();

        abstract Boolean getNonDeterministic();

        abstract Map<ByteString, ByteString> getState();

        @JsonCreator
        static CommonCoder create(@JsonProperty(value="urn") String urn, @JsonProperty(value="components") @Nullable List<CommonCoder> components, @JsonProperty(value="payload") @Nullable String payload, @JsonProperty(value="non_deterministic") @Nullable Boolean nonDeterministic, @JsonProperty(value="state") @Nullable Map<String, String> state) {
            if (state == null) {
                state = Collections.emptyMap();
            }
            HashMap<ByteString, ByteString> transformedState = new HashMap<ByteString, ByteString>();
            for (Map.Entry<String, String> entry : state.entrySet()) {
                transformedState.put(ByteString.copyFromUtf8((String)entry.getKey()), ByteString.copyFrom((byte[])entry.getValue().getBytes(StandardCharsets.ISO_8859_1)));
            }
            return new AutoValue_CommonCoderTest_CommonCoder((String)Preconditions.checkNotNull((Object)urn, (Object)"urn"), (List)MoreObjects.firstNonNull(components, Collections.emptyList()), ((String)MoreObjects.firstNonNull((Object)payload, (Object)"")).getBytes(StandardCharsets.ISO_8859_1), (Boolean)MoreObjects.firstNonNull((Object)nonDeterministic, (Object)Boolean.FALSE), transformedState);
        }
    }
}

