/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LengthPrefixUnknownCodersTest {
    @Rule
    public transient Timeout globalTimeout = Timeout.seconds((long)600L);
    @Parameterized.Parameter
    public Coder<?> original;
    @Parameterized.Parameter(value=1)
    public Coder<?> expected;
    @Parameterized.Parameter(value=2)
    public boolean replaceWithByteArray;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ImmutableList.of((Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)UnknownCoder.INSTANCE, (Coder)UnknownCoder.INSTANCE), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), false}, (Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)UnknownCoder.INSTANCE, (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), false}, (Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)UnknownCoder.INSTANCE), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)ByteArrayCoder.of()), (Coder)LengthPrefixCoder.of((Coder)ByteArrayCoder.of())), (Coder)GlobalWindow.Coder.INSTANCE), true}, (Object)new Object[]{LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), false}, (Object)new Object[]{LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), LengthPrefixCoder.of((Coder)ByteArrayCoder.of()), true});
    }

    @Test
    public void test() throws IOException {
        SdkComponents sdkComponents = SdkComponents.create();
        sdkComponents.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        String coderId = sdkComponents.registerCoder(this.original);
        RunnerApi.Components.Builder components = sdkComponents.toComponents().toBuilder();
        String updatedCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder((String)coderId, (RunnerApi.Components.Builder)components, (boolean)this.replaceWithByteArray);
        Assert.assertEquals(this.expected, (Object)RehydratedComponents.forComponents((RunnerApi.Components)components.build()).getCoder(updatedCoderId));
    }

    private static class UnknownCoder
    extends CustomCoder<String> {
        private static final Coder<?> INSTANCE = new UnknownCoder();

        private UnknownCoder() {
        }

        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return "";
        }

        public int hashCode() {
            return 1278890232;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof UnknownCoder;
        }
    }
}

