/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarUtils;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.commons.compress.utils.IOUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortablePipelineJarCreator
implements PortablePipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(PortablePipelineJarCreator.class);
    private final Class mainClass;
    @VisibleForTesting
    JarOutputStream outputStream;
    @VisibleForTesting
    WritableByteChannel outputChannel;

    public PortablePipelineJarCreator(Class mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public PortablePipelineResult run(RunnerApi.Pipeline pipeline, JobInfo jobInfo) throws Exception {
        PortablePipelineOptions pipelineOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
        String jobName = jobInfo.jobName();
        File outputFile = new File((String)Preconditions.checkArgumentNotNull((Object)pipelineOptions.getOutputExecutablePath()));
        LOG.info("Creating jar {} for job {}", (Object)outputFile.getAbsolutePath(), (Object)jobName);
        this.outputStream = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), this.createManifest(this.mainClass, jobName));
        this.outputChannel = Channels.newChannel(this.outputStream);
        PortablePipelineJarUtils.writeDefaultJobName(this.outputStream, jobName);
        this.copyResourcesFromJar(new JarFile(this.mainClass.getProtectionDomain().getCodeSource().getLocation().getPath()));
        this.writeAsJson((MessageOrBuilder)PipelineOptionsTranslation.toProto((PipelineOptions)pipelineOptions), PortablePipelineJarUtils.getPipelineOptionsUri(jobName));
        RunnerApi.Pipeline pipelineWithClasspathArtifacts = this.writeArtifacts(pipeline, jobName);
        this.writeAsJson((MessageOrBuilder)pipelineWithClasspathArtifacts, PortablePipelineJarUtils.getPipelineUri(jobName));
        this.outputChannel.close();
        LOG.info("Jar {} created successfully.", (Object)outputFile.getAbsolutePath());
        return new JarCreatorPipelineResult();
    }

    @VisibleForTesting
    Manifest createManifest(Class mainClass, String defaultJobName) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        boolean classHasMainMethod = false;
        try {
            Class<?> returnType = mainClass.getMethod("main", String[].class).getReturnType();
            if (returnType == Void.TYPE) {
                classHasMainMethod = true;
            } else {
                LOG.warn("No Main-Class will be set in jar because main method in {} returns {}, expected void", (Object)mainClass, returnType);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No Main-Class will be set in jar because {} lacks a main method.", (Object)mainClass);
        }
        if (classHasMainMethod) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        }
        return manifest;
    }

    @VisibleForTesting
    protected void copyResourcesFromJar(JarFile inputJar) throws IOException {
        Enumeration<JarEntry> inputJarEntries = inputJar.entries();
        HashSet<String> previousEntryNames = new HashSet<String>((Collection<String>)ImmutableList.of((Object)"META-INF/MANIFEST.MF"));
        while (inputJarEntries.hasMoreElements()) {
            JarEntry inputJarEntry = inputJarEntries.nextElement();
            InputStream inputStream = inputJar.getInputStream(inputJarEntry);
            String entryName = inputJarEntry.getName();
            if (previousEntryNames.contains(entryName)) {
                LOG.debug("Skipping duplicated file {}", (Object)entryName);
                continue;
            }
            JarEntry outputJarEntry = new JarEntry(inputJarEntry);
            this.outputStream.putNextEntry(outputJarEntry);
            LOG.trace("Copying jar entry {}", (Object)inputJarEntry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            previousEntryNames.add(entryName);
        }
    }

    @VisibleForTesting
    protected RunnerApi.Pipeline writeArtifacts(RunnerApi.Pipeline pipeline, String jobName) throws IOException {
        RunnerApi.Pipeline.Builder result = pipeline.toBuilder();
        for (Map.Entry env : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            result.getComponentsBuilder().putEnvironments((String)env.getKey(), this.writeArtifacts((RunnerApi.Environment)env.getValue(), jobName));
        }
        return result.build();
    }

    private RunnerApi.Environment writeArtifacts(RunnerApi.Environment environment, String jobName) throws IOException {
        RunnerApi.Environment.Builder result = environment.toBuilder();
        result.clearDependencies();
        for (RunnerApi.ArtifactInformation artifact : environment.getDependenciesList()) {
            result.addDependencies(this.writeArtifact(artifact, jobName));
        }
        return result.build();
    }

    private RunnerApi.ArtifactInformation writeArtifact(RunnerApi.ArtifactInformation artifact, String jobName) throws IOException {
        String path = PortablePipelineJarUtils.getArtifactUri(jobName, UUID.randomUUID().toString());
        LOG.trace("Copying artifact {} to {}", (Object)artifact, (Object)path);
        this.outputStream.putNextEntry(new JarEntry(path));
        try (InputStream artifactStream = ArtifactRetrievalService.getArtifact((RunnerApi.ArtifactInformation)artifact);){
            ByteStreams.copy((InputStream)artifactStream, (OutputStream)this.outputStream);
        }
        return artifact.toBuilder().setTypeUrn("beam:artifact:type:file:v1").setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath("classpath://" + path).build().toByteString()).build();
    }

    private void writeAsJson(MessageOrBuilder message, String outputPath) throws IOException {
        this.outputStream.putNextEntry(new JarEntry(outputPath));
        this.outputChannel.write(StandardCharsets.UTF_8.encode(JsonFormat.printer().print(message)));
    }

    private static class JarCreatorPipelineResult
    implements PortablePipelineResult {
        private JarCreatorPipelineResult() {
        }

        public PipelineResult.State getState() {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State cancel() {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State waitUntilFinish(Duration duration) {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State waitUntilFinish() {
            return PipelineResult.State.DONE;
        }

        public MetricResults metrics() {
            throw new UnsupportedOperationException("Jar creation does not yield metrics.");
        }

        @Override
        public JobApi.MetricResults portableMetrics() throws UnsupportedOperationException {
            return JobApi.MetricResults.getDefaultInstance();
        }
    }
}

