/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.util.Timestamps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.FutureCallback;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListenableFuture;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInvocation {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JobInvocation.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline;
    private final @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner pipelineRunner;
    private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private final @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService;
    private final @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent> stateHistory;
    private final @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessage> messageHistory;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Consumer<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent>> stateObservers;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Consumer<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessage>> messageObservers;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults metrics;
    private @UnknownKeyFor @NonNull @Initialized PortablePipelineResult resultHandle;
    private @Nullable @UnknownKeyFor @Initialized ListenableFuture<@UnknownKeyFor @NonNull @Initialized PortablePipelineResult> invocationFuture;

    public JobInvocation(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner pipelineRunner) {
        this.jobInfo = jobInfo;
        this.executorService = executorService;
        this.pipeline = pipeline;
        this.pipelineRunner = pipelineRunner;
        this.stateObservers = new ArrayList<Consumer<JobApi.JobStateEvent>>();
        this.messageObservers = new ArrayList<Consumer<JobApi.JobMessage>>();
        this.invocationFuture = null;
        this.stateHistory = new ArrayList<JobApi.JobStateEvent>();
        this.messageHistory = new ArrayList<JobApi.JobMessage>();
        this.metrics = JobApi.MetricResults.newBuilder().build();
        this.setState(JobApi.JobState.Enum.STOPPED);
    }

    private @UnknownKeyFor @NonNull @Initialized PortablePipelineResult runPipeline() throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.pipelineRunner.run(this.pipeline, this.jobInfo);
    }

    public synchronized void start() {
        LOG.info("Starting job invocation {}", (Object)this.getId());
        if (this.getState() != JobApi.JobState.Enum.STOPPED) {
            throw new IllegalStateException(String.format("Job %s already running.", this.getId()));
        }
        this.setState(JobApi.JobState.Enum.STARTING);
        this.invocationFuture = this.executorService.submit(this::runPipeline);
        this.setState(JobApi.JobState.Enum.RUNNING);
        Futures.addCallback(this.invocationFuture, (FutureCallback)new FutureCallback<PortablePipelineResult>(){

            public void onSuccess(@UnknownKeyFor @NonNull @Initialized PortablePipelineResult pipelineResult) {
                if (pipelineResult != null) {
                    PipelineResult.State state = pipelineResult.getState();
                    if (state.isTerminal()) {
                        JobInvocation.this.metrics = pipelineResult.portableMetrics();
                    } else {
                        JobInvocation.this.resultHandle = pipelineResult;
                    }
                    switch (state) {
                        case DONE: {
                            JobInvocation.this.setState(JobApi.JobState.Enum.DONE);
                            break;
                        }
                        case RUNNING: {
                            JobInvocation.this.setState(JobApi.JobState.Enum.RUNNING);
                            break;
                        }
                        case CANCELLED: {
                            JobInvocation.this.setState(JobApi.JobState.Enum.CANCELLED);
                            break;
                        }
                        case FAILED: {
                            JobInvocation.this.setState(JobApi.JobState.Enum.FAILED);
                            break;
                        }
                        default: {
                            JobInvocation.this.setState(JobApi.JobState.Enum.UNSPECIFIED);
                            break;
                        }
                    }
                } else {
                    JobInvocation.this.setState(JobApi.JobState.Enum.UNSPECIFIED);
                }
            }

            public void onFailure(@Nonnull @UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                if (throwable instanceof CancellationException) {
                    JobInvocation.this.setState(JobApi.JobState.Enum.CANCELLED);
                    return;
                }
                String message = String.format("Error during job invocation %s.", JobInvocation.this.getId());
                LOG.error(message, throwable);
                JobInvocation.this.sendMessage(JobApi.JobMessage.newBuilder().setMessageText(Throwables.getStackTraceAsString((Throwable)throwable)).setImportance(JobApi.JobMessage.MessageImportance.JOB_MESSAGE_DEBUG).build());
                JobInvocation.this.sendMessage(JobApi.JobMessage.newBuilder().setMessageText(Throwables.getRootCause((Throwable)throwable).toString()).setImportance(JobApi.JobMessage.MessageImportance.JOB_MESSAGE_ERROR).build());
                JobInvocation.this.setState(JobApi.JobState.Enum.FAILED);
            }
        }, (Executor)this.executorService);
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.jobInfo.jobId();
    }

    public synchronized void cancel() {
        LOG.info("Canceling job invocation {}", (Object)this.getId());
        if (this.invocationFuture != null) {
            this.invocationFuture.cancel(true);
            Futures.addCallback(this.invocationFuture, (FutureCallback)new FutureCallback<PortablePipelineResult>(){

                public void onSuccess(@UnknownKeyFor @NonNull @Initialized PortablePipelineResult pipelineResult) {
                    if (pipelineResult != null && pipelineResult.getState() != PipelineResult.State.DONE) {
                        try {
                            pipelineResult.cancel();
                            JobInvocation.this.setState(JobApi.JobState.Enum.CANCELLED);
                        }
                        catch (IOException exn) {
                            throw new RuntimeException(exn);
                        }
                    }
                }

                public void onFailure(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                }
            }, (Executor)this.executorService);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults getMetrics() {
        if (this.resultHandle != null) {
            this.metrics = this.resultHandle.portableMetrics();
        }
        return this.metrics;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobState.Enum getState() {
        return this.getStateEvent().getState();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent getStateEvent() {
        return this.stateHistory.get(this.stateHistory.size() - 1);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline getPipeline() {
        return this.pipeline;
    }

    public synchronized void addStateListener(@UnknownKeyFor @NonNull @Initialized Consumer<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent> stateStreamObserver) {
        for (JobApi.JobStateEvent event : this.stateHistory) {
            stateStreamObserver.accept(event);
        }
        this.stateObservers.add(stateStreamObserver);
    }

    public synchronized void addMessageListener(@UnknownKeyFor @NonNull @Initialized Consumer<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessage> messageStreamObserver) {
        for (JobApi.JobMessage msg : this.messageHistory) {
            messageStreamObserver.accept(msg);
        }
        this.messageObservers.add(messageStreamObserver);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobInfo toProto() {
        return JobApi.JobInfo.newBuilder().setJobId(this.jobInfo.jobId()).setJobName(this.jobInfo.jobName()).setPipelineOptions(this.jobInfo.pipelineOptions()).setState(this.getState()).build();
    }

    private synchronized void setState(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobState.Enum state) {
        JobApi.JobStateEvent event = JobApi.JobStateEvent.newBuilder().setState(state).setTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).build();
        this.stateHistory.add(event);
        for (Consumer<JobApi.JobStateEvent> observer : this.stateObservers) {
            observer.accept(event);
        }
    }

    private synchronized void sendMessage(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessage message) {
        this.messageHistory.add(message);
        for (Consumer<JobApi.JobMessage> observer : this.messageObservers) {
            observer.accept(message);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Boolean isTerminated(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobState.Enum state) {
        switch (state) {
            case DONE: 
            case FAILED: 
            case CANCELLED: 
            case DRAINED: {
                return true;
            }
        }
        return false;
    }
}

