/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarUtils;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.commons.compress.utils.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortablePipelineJarCreator
implements PortablePipelineRunner {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PortablePipelineJarCreator.class);
    private final @UnknownKeyFor @NonNull @Initialized Class mainClass;
    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized JarOutputStream outputStream;
    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized WritableByteChannel outputChannel;

    public PortablePipelineJarCreator(@UnknownKeyFor @NonNull @Initialized Class mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PortablePipelineResult run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) throws @UnknownKeyFor @NonNull @Initialized Exception {
        PortablePipelineOptions pipelineOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
        String jobName = jobInfo.jobName();
        File outputFile = new File((String)Preconditions.checkArgumentNotNull((Object)pipelineOptions.getOutputExecutablePath()));
        LOG.info("Creating jar {} for job {}", (Object)outputFile.getAbsolutePath(), (Object)jobName);
        this.outputStream = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), this.createManifest(this.mainClass, jobName));
        this.outputChannel = Channels.newChannel(this.outputStream);
        PortablePipelineJarUtils.writeDefaultJobName(this.outputStream, jobName);
        this.copyResourcesFromJar(new JarFile(this.mainClass.getProtectionDomain().getCodeSource().getLocation().getPath()));
        this.writeAsJson((MessageOrBuilder)PipelineOptionsTranslation.toProto((PipelineOptions)pipelineOptions), PortablePipelineJarUtils.getPipelineOptionsUri(jobName));
        RunnerApi.Pipeline pipelineWithClasspathArtifacts = this.writeArtifacts(pipeline, jobName);
        this.writeAsJson((MessageOrBuilder)pipelineWithClasspathArtifacts, PortablePipelineJarUtils.getPipelineUri(jobName));
        this.outputChannel.close();
        LOG.info("Jar {} created successfully.", (Object)outputFile.getAbsolutePath());
        return new JarCreatorPipelineResult();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Manifest createManifest(@UnknownKeyFor @NonNull @Initialized Class mainClass, @UnknownKeyFor @NonNull @Initialized String defaultJobName) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        boolean classHasMainMethod = false;
        try {
            Class<?> returnType = mainClass.getMethod("main", String[].class).getReturnType();
            if (returnType == Void.TYPE) {
                classHasMainMethod = true;
            } else {
                LOG.warn("No Main-Class will be set in jar because main method in {} returns {}, expected void", (Object)mainClass, returnType);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No Main-Class will be set in jar because {} lacks a main method.", (Object)mainClass);
        }
        if (classHasMainMethod) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        }
        return manifest;
    }

    @VisibleForTesting
    protected void copyResourcesFromJar(@UnknownKeyFor @NonNull @Initialized JarFile inputJar) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Enumeration<JarEntry> inputJarEntries = inputJar.entries();
        HashSet<String> previousEntryNames = new HashSet<String>((Collection<String>)ImmutableList.of((Object)"META-INF/MANIFEST.MF"));
        while (inputJarEntries.hasMoreElements()) {
            JarEntry inputJarEntry = inputJarEntries.nextElement();
            InputStream inputStream = inputJar.getInputStream(inputJarEntry);
            String entryName = inputJarEntry.getName();
            if (previousEntryNames.contains(entryName)) {
                LOG.debug("Skipping duplicated file {}", (Object)entryName);
                continue;
            }
            JarEntry outputJarEntry = new JarEntry(inputJarEntry);
            this.outputStream.putNextEntry(outputJarEntry);
            LOG.trace("Copying jar entry {}", (Object)inputJarEntry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            previousEntryNames.add(entryName);
        }
    }

    @VisibleForTesting
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline writeArtifacts(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.Pipeline.Builder result = pipeline.toBuilder();
        for (Map.Entry env : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            result.getComponentsBuilder().putEnvironments((String)env.getKey(), this.writeArtifacts((RunnerApi.Environment)env.getValue(), jobName));
        }
        return result.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment writeArtifacts(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.Environment.Builder result = environment.toBuilder();
        result.clearDependencies();
        for (RunnerApi.ArtifactInformation artifact : environment.getDependenciesList()) {
            result.addDependencies(this.writeArtifact(artifact, jobName));
        }
        return result.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation writeArtifact(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation artifact, @UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String path = PortablePipelineJarUtils.getArtifactUri(jobName, UUID.randomUUID().toString());
        LOG.trace("Copying artifact {} to {}", (Object)artifact, (Object)path);
        this.outputStream.putNextEntry(new JarEntry(path));
        try (InputStream artifactStream = ArtifactRetrievalService.getArtifact((RunnerApi.ArtifactInformation)artifact);){
            ByteStreams.copy((InputStream)artifactStream, (OutputStream)this.outputStream);
        }
        return artifact.toBuilder().setTypeUrn("beam:artifact:type:file:v1").setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath("classpath://" + path).build().toByteString()).build();
    }

    private void writeAsJson(@UnknownKeyFor @NonNull @Initialized MessageOrBuilder message, @UnknownKeyFor @NonNull @Initialized String outputPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.outputStream.putNextEntry(new JarEntry(outputPath));
        this.outputChannel.write(StandardCharsets.UTF_8.encode(JsonFormat.printer().print(message)));
    }

    private static class JarCreatorPipelineResult
    implements PortablePipelineResult {
        private JarCreatorPipelineResult() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
            return PipelineResult.State.DONE;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() {
            return PipelineResult.State.DONE;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
            return PipelineResult.State.DONE;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
            return PipelineResult.State.DONE;
        }

        public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
            throw new UnsupportedOperationException("Jar creation does not yield metrics.");
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults portableMetrics() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            return JobApi.MetricResults.getDefaultInstance();
        }
    }
}

