/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineValidator;
import org.apache.beam.runners.fnexecution.artifact.ArtifactStagingService;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.JobInvoker;
import org.apache.beam.runners.jobsubmission.JobPreparation;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.stream.SynchronizedStreamObserver;
import org.apache.beam.sdk.function.ThrowingConsumer;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobService
extends JobServiceGrpc.JobServiceImplBase
implements FnService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(InMemoryJobService.class);
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_INVOCATION_HISTORY = 10;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JobPreparation> preparations;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stagingSessionTokens;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JobInvocation> invocations;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedDeque<@UnknownKeyFor @NonNull @Initialized String> completedInvocationsIds;
    private final @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactStagingService> stagingService;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor stagingServiceDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stagingServiceTokenProvider;
    private final @UnknownKeyFor @NonNull @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized String> cleanupJobFn;
    private final @UnknownKeyFor @NonNull @Initialized JobInvoker invoker;
    private final @UnknownKeyFor @NonNull @Initialized int maxInvocationHistory;

    public static @UnknownKeyFor @NonNull @Initialized InMemoryJobService create(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactStagingService> stagingService, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stagingServiceTokenProvider, @UnknownKeyFor @NonNull @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized String> cleanupJobFn, @UnknownKeyFor @NonNull @Initialized JobInvoker invoker) {
        return new InMemoryJobService(stagingService, stagingServiceTokenProvider, cleanupJobFn, invoker, 10);
    }

    public static @UnknownKeyFor @NonNull @Initialized InMemoryJobService create(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactStagingService> stagingService, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stagingServiceTokenProvider, @UnknownKeyFor @NonNull @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized String> cleanupJobFn, @UnknownKeyFor @NonNull @Initialized JobInvoker invoker, @UnknownKeyFor @NonNull @Initialized int maxInvocationHistory) {
        return new InMemoryJobService(stagingService, stagingServiceTokenProvider, cleanupJobFn, invoker, maxInvocationHistory);
    }

    private InMemoryJobService(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactStagingService> stagingService, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stagingServiceTokenProvider, @UnknownKeyFor @NonNull @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized String> cleanupJobFn, @UnknownKeyFor @NonNull @Initialized JobInvoker invoker, @UnknownKeyFor @NonNull @Initialized int maxInvocationHistory) {
        this.stagingService = stagingService;
        this.stagingServiceDescriptor = stagingService.getApiServiceDescriptor();
        this.stagingServiceTokenProvider = stagingServiceTokenProvider;
        this.cleanupJobFn = cleanupJobFn;
        this.invoker = invoker;
        this.preparations = new ConcurrentHashMap();
        this.invocations = new ConcurrentHashMap();
        this.stagingSessionTokens = new ConcurrentHashMap();
        this.completedInvocationsIds = new ConcurrentLinkedDeque();
        Preconditions.checkArgument((maxInvocationHistory >= 0 ? 1 : 0) != 0);
        this.maxInvocationHistory = maxInvocationHistory;
    }

    public void prepare(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PrepareJobRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PrepareJobResponse> responseObserver) {
        try {
            LOG.trace("{} {}", (Object)JobApi.PrepareJobRequest.class.getSimpleName(), (Object)request);
            String preparationId = String.format("%s_%s", request.getJobName(), UUID.randomUUID().toString());
            Struct pipelineOptions = request.getPipelineOptions();
            if (pipelineOptions == null) {
                throw new NullPointerException("Encountered null pipeline options.");
            }
            LOG.trace("PIPELINE OPTIONS {} {}", pipelineOptions.getClass(), (Object)pipelineOptions);
            JobPreparation preparation = JobPreparation.builder().setId(preparationId).setPipeline(request.getPipeline()).setOptions(pipelineOptions).build();
            JobPreparation previous = this.preparations.putIfAbsent(preparationId, preparation);
            if (previous != null) {
                String errMessage = String.format("A job with the preparation ID \"%s\" already exists.", preparationId);
                StatusException exception = Status.NOT_FOUND.withDescription(errMessage).asException();
                responseObserver.onError((Throwable)exception);
                return;
            }
            String stagingSessionToken = this.stagingServiceTokenProvider.apply(preparationId);
            this.stagingSessionTokens.putIfAbsent(preparationId, stagingSessionToken);
            ((ArtifactStagingService)this.stagingService.getService()).registerJob(stagingSessionToken, Maps.transformValues((Map)request.getPipeline().getComponents().getEnvironmentsMap(), RunnerApi.Environment::getDependenciesList));
            JobApi.PrepareJobResponse response = JobApi.PrepareJobResponse.newBuilder().setPreparationId(preparationId).setArtifactStagingEndpoint(this.stagingServiceDescriptor).setStagingSessionToken(stagingSessionToken).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Could not prepare job with name {}", (Object)request.getJobName(), (Object)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.RunJobRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.RunJobResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.RunJobRequest.class.getSimpleName(), (Object)request);
        String preparationId = request.getPreparationId();
        try {
            JobPreparation preparation = this.preparations.get(preparationId);
            if (preparation == null) {
                String errMessage = String.format("Unknown Preparation Id \"%s\".", preparationId);
                StatusException exception = Status.NOT_FOUND.withDescription(errMessage).asException();
                responseObserver.onError((Throwable)exception);
                return;
            }
            try {
                PipelineValidator.validate((RunnerApi.Pipeline)preparation.pipeline());
            }
            catch (Exception e) {
                LOG.warn("Encountered Unexpected Exception during validation", (Throwable)e);
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e)));
                return;
            }
            JobInvocation invocation = this.invoker.invoke(this.resolveDependencies(preparation.pipeline(), this.stagingSessionTokens.get(preparationId)), preparation.options(), request.getRetrievalToken());
            String invocationId = invocation.getId();
            invocation.addStateListener(event -> {
                if (!JobInvocation.isTerminated(event.getState()).booleanValue()) {
                    return;
                }
                String stagingSessionToken = this.stagingSessionTokens.get(preparationId);
                this.stagingSessionTokens.remove(preparationId);
                try {
                    if (this.cleanupJobFn != null) {
                        this.cleanupJobFn.accept((Object)stagingSessionToken);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove job staging directory for token {}.", (Object)stagingSessionToken, (Object)e);
                }
                finally {
                    this.onFinishedInvocationCleanup(invocationId);
                }
            });
            invocation.start();
            this.invocations.put(invocationId, invocation);
            this.preparations.remove(preparationId);
            JobApi.RunJobResponse response = JobApi.RunJobResponse.newBuilder().setJobId(invocationId).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            LOG.warn("Encountered Status Exception", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Preparation %s", preparationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline resolveDependencies(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized String stagingToken) {
        Map resolvedDependencies = ((ArtifactStagingService)this.stagingService.getService()).getStagedArtifacts(stagingToken);
        HashMap<String, RunnerApi.Environment> newEnvironments = new HashMap<String, RunnerApi.Environment>();
        for (Map.Entry entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            if (((RunnerApi.Environment)entry.getValue()).getDependenciesCount() > 0 && resolvedDependencies == null) {
                throw new RuntimeException("Artifact dependencies provided but not staged for " + (String)entry.getKey());
            }
            newEnvironments.put((String)entry.getKey(), ((RunnerApi.Environment)entry.getValue()).getDependenciesCount() == 0 ? (RunnerApi.Environment)entry.getValue() : ((RunnerApi.Environment)entry.getValue()).toBuilder().clearDependencies().addAllDependencies((Iterable)resolvedDependencies.get(entry.getKey())).build());
        }
        RunnerApi.Pipeline.Builder builder = pipeline.toBuilder();
        builder.getComponentsBuilder().clearEnvironments().putAllEnvironments(newEnvironments);
        return builder.build();
    }

    public void getJobs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobsRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobsResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobsRequest.class.getSimpleName(), (Object)request);
        try {
            ArrayList<JobApi.JobInfo> result = new ArrayList<JobApi.JobInfo>();
            for (JobInvocation invocation : this.invocations.values()) {
                result.add(invocation.toProto());
            }
            JobApi.GetJobsResponse response = JobApi.GetJobsResponse.newBuilder().addAllJobInfo(result).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Encountered Unexpected Exception", (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getState(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobStateRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobStateRequest.class.getSimpleName(), (Object)request);
        String invocationId = request.getJobId();
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            JobApi.JobStateEvent response = invocation.getStateEvent();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getPipeline(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobPipelineRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobPipelineResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobPipelineRequest.class.getSimpleName(), (Object)request);
        String invocationId = request.getJobId();
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            RunnerApi.Pipeline pipeline = invocation.getPipeline();
            JobApi.GetJobPipelineResponse response = JobApi.GetJobPipelineResponse.newBuilder().setPipeline(pipeline).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void cancel(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.CancelJobRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.CancelJobResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.CancelJobRequest.class.getSimpleName(), (Object)request);
        String invocationId = request.getJobId();
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            invocation.cancel();
            JobApi.JobState.Enum state = invocation.getState();
            JobApi.CancelJobResponse response = JobApi.CancelJobResponse.newBuilder().setState(state).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getStateStream(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobStateRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobStateEvent> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobStateRequest.class.getSimpleName(), (Object)request);
        String invocationId = request.getJobId();
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            Consumer<JobApi.JobStateEvent> stateListener = event -> {
                responseObserver.onNext(event);
                if (JobInvocation.isTerminated(event.getState()).booleanValue()) {
                    responseObserver.onCompleted();
                }
            };
            invocation.addStateListener(stateListener);
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getMessageStream(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessagesRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobMessagesResponse> responseObserver) {
        String invocationId = request.getJobId();
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            StreamObserver syncResponseObserver = SynchronizedStreamObserver.wrapping(responseObserver);
            Consumer<JobApi.JobStateEvent> stateListener = event -> {
                syncResponseObserver.onNext((Object)JobApi.JobMessagesResponse.newBuilder().setStateResponse(event).build());
                if (JobInvocation.isTerminated(invocation.getStateEvent().getState()).booleanValue()) {
                    responseObserver.onCompleted();
                }
            };
            Consumer<JobApi.JobMessage> messageListener = message -> syncResponseObserver.onNext((Object)JobApi.JobMessagesResponse.newBuilder().setMessageResponse(message).build());
            invocation.addMessageListener(messageListener);
            invocation.addStateListener(stateListener);
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getJobMetrics(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobMetricsRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.GetJobMetricsResponse> responseObserver) {
        String invocationId = request.getJobId();
        LOG.info("Getting job metrics for {}", (Object)invocationId);
        try {
            JobInvocation invocation = this.getInvocation(invocationId);
            JobApi.MetricResults metrics = invocation.getMetrics();
            JobApi.GetJobMetricsResponse response = JobApi.GetJobMetricsResponse.newBuilder().setMetrics(metrics).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusException | StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            LOG.error(String.format("Encountered exception for job invocation %s", invocationId), (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
        LOG.info("Finished getting job metrics for {}", (Object)invocationId);
    }

    public void describePipelineOptions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.DescribePipelineOptionsRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.DescribePipelineOptionsResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.DescribePipelineOptionsRequest.class.getSimpleName(), (Object)request);
        try {
            JobApi.DescribePipelineOptionsResponse response = JobApi.DescribePipelineOptionsResponse.newBuilder().addAllOptions((Iterable)PipelineOptionsFactory.describe((Set)PipelineOptionsFactory.getRegisteredOptions())).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Error describing pipeline options", (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    private @UnknownKeyFor @NonNull @Initialized JobInvocation getInvocation(@UnknownKeyFor @NonNull @Initialized String invocationId) throws @UnknownKeyFor @NonNull @Initialized StatusException {
        JobInvocation invocation = this.invocations.get(invocationId);
        if (invocation == null) {
            throw Status.NOT_FOUND.asException();
        }
        return invocation;
    }

    private void onFinishedInvocationCleanup(@UnknownKeyFor @NonNull @Initialized String invocationId) {
        this.completedInvocationsIds.addLast(invocationId);
        while (this.completedInvocationsIds.size() > this.maxInvocationHistory) {
            this.invocations.remove(this.completedInvocationsIds.removeFirst());
        }
    }
}

