/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class PortablePipelineJarUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String ARTIFACT_FOLDER = "artifacts";
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_FOLDER = "BEAM-PIPELINE";
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE = "pipeline.json";
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_OPTIONS = "pipeline-options.json";
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_MANIFEST = "BEAM-PIPELINE/pipeline-manifest.json";
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper OBJECT_MAPPER = new ObjectMapper(new JsonFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false));

    private static @UnknownKeyFor @NonNull @Initialized InputStream getResourceFromClassPath(@UnknownKeyFor @NonNull @Initialized String resourcePath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStream inputStream = PortablePipelineJarUtils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("Resource %s not found on classpath.", resourcePath));
        }
        return inputStream;
    }

    private static void parseJsonResource(@UnknownKeyFor @NonNull @Initialized String resourcePath, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Message.Builder builder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(resourcePath);){
            String contents = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
            JsonFormat.parser().merge(contents, builder);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline getPipelineFromClasspath(@UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.Pipeline.Builder builder = RunnerApi.Pipeline.newBuilder();
        PortablePipelineJarUtils.parseJsonResource(PortablePipelineJarUtils.getPipelineUri(jobName), (Message.Builder)builder);
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Struct getPipelineOptionsFromClasspath(@UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Struct.Builder builder = Struct.newBuilder();
        PortablePipelineJarUtils.parseJsonResource(PortablePipelineJarUtils.getPipelineOptionsUri(jobName), (Message.Builder)builder);
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized String getPipelineUri(@UnknownKeyFor @NonNull @Initialized String jobName) {
        return "BEAM-PIPELINE/" + jobName + "/" + PIPELINE;
    }

    static @UnknownKeyFor @NonNull @Initialized String getPipelineOptionsUri(@UnknownKeyFor @NonNull @Initialized String jobName) {
        return "BEAM-PIPELINE/" + jobName + "/" + PIPELINE_OPTIONS;
    }

    static @UnknownKeyFor @NonNull @Initialized String getArtifactUri(@UnknownKeyFor @NonNull @Initialized String jobName, @UnknownKeyFor @NonNull @Initialized String artifactId) {
        return "BEAM-PIPELINE/" + jobName + "/" + ARTIFACT_FOLDER + "/" + artifactId;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getDefaultJobName() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(PIPELINE_MANIFEST);){
            PipelineManifest pipelineManifest = (PipelineManifest)OBJECT_MAPPER.readValue(inputStream, PipelineManifest.class);
            String string = pipelineManifest.defaultJobName;
            return string;
        }
    }

    public static void writeDefaultJobName(@UnknownKeyFor @NonNull @Initialized JarOutputStream outputStream, @UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        outputStream.putNextEntry(new JarEntry(PIPELINE_MANIFEST));
        PipelineManifest pipelineManifest = new PipelineManifest();
        pipelineManifest.defaultJobName = jobName;
        OBJECT_MAPPER.writeValue((OutputStream)outputStream, (Object)pipelineManifest);
    }

    private static class PipelineManifest {
        public @UnknownKeyFor @NonNull @Initialized String defaultJobName;

        private PipelineManifest() {
        }
    }
}

