/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.portability;

import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CloseableResource<@UnknownKeyFor T>
implements AutoCloseable {
    private final T resource;
    private @Nullable @UnknownKeyFor @Initialized Closer<T> closer;
    private @UnknownKeyFor @NonNull @Initialized boolean isClosed = false;

    private CloseableResource(T resource, @UnknownKeyFor @NonNull @Initialized Closer<T> closer) {
        this.resource = resource;
        this.closer = closer;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CloseableResource<T> of(T resource, @UnknownKeyFor @NonNull @Initialized Closer<T> closer) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Resource must be non-null");
        Preconditions.checkArgument((closer != null ? 1 : 0) != 0, (String)"%s must be non-null", (Object)Closer.class.getName());
        return new CloseableResource<T>(resource, closer);
    }

    public T get() {
        Preconditions.checkState((this.closer != null ? 1 : 0) != 0, (String)"%s has transferred ownership", (Object)CloseableResource.class.getName());
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"% is closed", (Object)CloseableResource.class.getName());
        return this.resource;
    }

    public @UnknownKeyFor @NonNull @Initialized CloseableResource<T> transfer() {
        Preconditions.checkState((this.closer != null ? 1 : 0) != 0, (String)"%s has transferred ownership", (Object)CloseableResource.class.getName());
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"% is closed", (Object)CloseableResource.class.getName());
        CloseableResource<T> other = CloseableResource.of(this.resource, this.closer);
        this.closer = null;
        return other;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized CloseException {
        if (this.closer != null && !this.isClosed) {
            try {
                this.closer.close(this.resource);
            }
            catch (Exception e) {
                throw new CloseException(e);
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public static class CloseException
    extends Exception {
        private CloseException(@UnknownKeyFor @NonNull @Initialized Exception e) {
            super("Error closing resource", e);
        }
    }

    @FunctionalInterface
    public static interface Closer<@UnknownKeyFor T> {
        public void close(T var1) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

