/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.portability;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.runners.portability.CloseableResource;
import org.apache.beam.runners.portability.PortableMetrics;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobServicePipelineResult
implements PipelineResult,
AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized long POLL_INTERVAL_MS = 3000L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JobServicePipelineResult.class);
    private final @UnknownKeyFor @NonNull @Initialized ByteString jobId;
    private final @UnknownKeyFor @NonNull @Initialized int jobServerTimeout;
    private final @UnknownKeyFor @NonNull @Initialized CloseableResource<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub> jobService;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized PipelineResult.State terminalState;
    private final @Nullable @UnknownKeyFor @Initialized Runnable cleanup;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults jobMetrics;

    JobServicePipelineResult(@UnknownKeyFor @NonNull @Initialized ByteString jobId, @UnknownKeyFor @NonNull @Initialized int jobServerTimeout, @UnknownKeyFor @NonNull @Initialized CloseableResource<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub> jobService, @UnknownKeyFor @NonNull @Initialized Runnable cleanup) {
        this.jobId = jobId;
        this.jobServerTimeout = jobServerTimeout;
        this.jobService = jobService;
        this.terminalState = null;
        this.cleanup = cleanup;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        JobServiceGrpc.JobServiceBlockingStub stub = (JobServiceGrpc.JobServiceBlockingStub)this.jobService.get().withDeadlineAfter((long)this.jobServerTimeout, TimeUnit.SECONDS);
        JobApi.JobStateEvent response = stub.getState(JobApi.GetJobStateRequest.newBuilder().setJobIdBytes(this.jobId).build());
        return JobServicePipelineResult.getJavaState(response.getState());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() {
        JobServiceGrpc.JobServiceBlockingStub stub = this.jobService.get();
        JobApi.CancelJobResponse response = stub.cancel(JobApi.CancelJobRequest.newBuilder().setJobIdBytes(this.jobId).build());
        return JobServicePipelineResult.getJavaState(response.getState());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        if (duration.compareTo((ReadableDuration)Duration.millis((long)1L)) <= 0) {
            return this.waitUntilFinish();
        }
        CompletableFuture<PipelineResult.State> result = CompletableFuture.supplyAsync(this::waitUntilFinish);
        try {
            return result.get(duration.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        try {
            this.waitForTerminalState();
            this.propagateErrors();
            PipelineResult.State state = this.terminalState;
            return state;
        }
        finally {
            this.close();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return PortableMetrics.of(this.jobMetrics);
    }

    @Override
    public void close() {
        try (CloseableResource<JobServiceGrpc.JobServiceBlockingStub> jobService = this.jobService;){
            JobApi.GetJobMetricsRequest metricsRequest = JobApi.GetJobMetricsRequest.newBuilder().setJobIdBytes(this.jobId).build();
            this.jobMetrics = jobService.get().getJobMetrics(metricsRequest).getMetrics();
            if (this.cleanup != null) {
                this.cleanup.run();
            }
        }
        catch (Exception e) {
            LOG.warn("Error cleaning up job service", (Throwable)e);
        }
    }

    private void waitForTerminalState() {
        JobServiceGrpc.JobServiceBlockingStub stub = (JobServiceGrpc.JobServiceBlockingStub)this.jobService.get().withDeadlineAfter((long)this.jobServerTimeout, TimeUnit.SECONDS);
        JobApi.GetJobStateRequest request = JobApi.GetJobStateRequest.newBuilder().setJobIdBytes(this.jobId).build();
        JobApi.JobStateEvent response = stub.getState(request);
        PipelineResult.State lastState = JobServicePipelineResult.getJavaState(response.getState());
        while (!lastState.isTerminal()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            response = ((JobServiceGrpc.JobServiceBlockingStub)stub.withDeadlineAfter((long)this.jobServerTimeout, TimeUnit.SECONDS)).getState(request);
            lastState = JobServicePipelineResult.getJavaState(response.getState());
        }
        this.terminalState = lastState;
    }

    private void propagateErrors() {
        if (this.terminalState != PipelineResult.State.DONE) {
            JobApi.JobMessagesRequest messageStreamRequest = JobApi.JobMessagesRequest.newBuilder().setJobIdBytes(this.jobId).build();
            Iterator messageStreamIterator = ((JobServiceGrpc.JobServiceBlockingStub)this.jobService.get().withDeadlineAfter((long)this.jobServerTimeout, TimeUnit.SECONDS)).getMessageStream(messageStreamRequest);
            while (messageStreamIterator.hasNext()) {
                JobApi.JobMessage messageResponse = ((JobApi.JobMessagesResponse)messageStreamIterator.next()).getMessageResponse();
                if (messageResponse.getImportance() != JobApi.JobMessage.MessageImportance.JOB_MESSAGE_ERROR) continue;
                throw new RuntimeException("The Runner experienced the following error during execution:\n" + messageResponse.getMessageText());
            }
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getJavaState(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobState.Enum protoState) {
        switch (protoState) {
            case UNSPECIFIED: {
                return PipelineResult.State.UNKNOWN;
            }
            case STOPPED: {
                return PipelineResult.State.STOPPED;
            }
            case RUNNING: {
                return PipelineResult.State.RUNNING;
            }
            case DONE: {
                return PipelineResult.State.DONE;
            }
            case FAILED: {
                return PipelineResult.State.FAILED;
            }
            case CANCELLED: {
                return PipelineResult.State.CANCELLED;
            }
            case UPDATED: {
                return PipelineResult.State.UPDATED;
            }
            case DRAINING: {
                return PipelineResult.State.UNKNOWN;
            }
            case DRAINED: {
                return PipelineResult.State.UNKNOWN;
            }
            case STARTING: {
                return PipelineResult.State.RUNNING;
            }
            case CANCELLING: {
                return PipelineResult.State.CANCELLED;
            }
        }
        LOG.warn("Unrecognized state from server: {}", (Object)protoState);
        return PipelineResult.State.UNKNOWN;
    }
}

