/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.portability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class PortableMetrics
extends MetricResults {
    private static final @UnknownKeyFor @NonNull @Initialized String NAMESPACE_LABEL = "NAMESPACE";
    private static final @UnknownKeyFor @NonNull @Initialized String METRIC_NAME_LABEL = "NAME";
    private static final @UnknownKeyFor @NonNull @Initialized String STEP_NAME_LABEL = "PTRANSFORM";
    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters;
    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions;
    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges;

    private PortableMetrics(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges) {
        this.counters = counters;
        this.distributions = distributions;
        this.gauges = gauges;
    }

    public static @UnknownKeyFor @NonNull @Initialized PortableMetrics of(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults jobMetrics) {
        return PortableMetrics.convertMonitoringInfosToMetricResults(jobMetrics);
    }

    public @UnknownKeyFor @NonNull @Initialized MetricQueryResults queryMetrics(@UnknownKeyFor @NonNull @Initialized MetricsFilter filter) {
        return MetricQueryResults.create((Iterable)Iterables.filter(this.counters, counter -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)counter.getKey())), (Iterable)Iterables.filter(this.distributions, distribution -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)distribution.getKey())), (Iterable)Iterables.filter(this.gauges, gauge -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)gauge.getKey())));
    }

    private static @UnknownKeyFor @NonNull @Initialized PortableMetrics convertMonitoringInfosToMetricResults(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults jobMetrics) {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfoList = new ArrayList<MetricsApi.MonitoringInfo>();
        monitoringInfoList.addAll(jobMetrics.getAttemptedList());
        monitoringInfoList.addAll(jobMetrics.getCommittedList());
        Iterable<MetricResult<Long>> countersFromJobMetrics = PortableMetrics.extractCountersFromJobMetrics(monitoringInfoList);
        Iterable<MetricResult<DistributionResult>> distributionsFromMetrics = PortableMetrics.extractDistributionMetricsFromJobMetrics(monitoringInfoList);
        Iterable<MetricResult<GaugeResult>> gaugesFromMetrics = PortableMetrics.extractGaugeMetricsFromJobMetrics(monitoringInfoList);
        return new PortableMetrics(countersFromJobMetrics, distributionsFromMetrics, gaugesFromMetrics);
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> extractDistributionMetricsFromJobMetrics(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> monitoringInfoList) {
        return monitoringInfoList.stream().filter(item -> "beam:metrics:distribution_int64:v1".equals(item.getType())).filter(item -> item.getLabelsMap().get(NAMESPACE_LABEL) != null).map(PortableMetrics::convertDistributionMonitoringInfoToDistribution).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> extractGaugeMetricsFromJobMetrics(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> monitoringInfoList) {
        return monitoringInfoList.stream().filter(item -> "beam:metrics:latest_int64:v1".equals(item.getType())).filter(item -> item.getLabelsMap().get(NAMESPACE_LABEL) != null).map(PortableMetrics::convertGaugeMonitoringInfoToGauge).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult> convertGaugeMonitoringInfoToGauge(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        Map labelsMap = monitoringInfo.getLabelsMap();
        MetricKey key = MetricKey.create((String)((String)labelsMap.get(STEP_NAME_LABEL)), (MetricName)MetricName.named((String)((String)labelsMap.get(NAMESPACE_LABEL)), (String)((String)labelsMap.get(METRIC_NAME_LABEL))));
        GaugeData data = MonitoringInfoEncodings.decodeInt64Gauge((ByteString)monitoringInfo.getPayload());
        GaugeResult result = GaugeResult.create((long)data.value(), (Instant)data.timestamp());
        return MetricResult.create((MetricKey)key, (Boolean)false, (Object)result);
    }

    private static @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult> convertDistributionMonitoringInfoToDistribution(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        Map labelsMap = monitoringInfo.getLabelsMap();
        MetricKey key = MetricKey.create((String)((String)labelsMap.get(STEP_NAME_LABEL)), (MetricName)MetricName.named((String)((String)labelsMap.get(NAMESPACE_LABEL)), (String)((String)labelsMap.get(METRIC_NAME_LABEL))));
        DistributionData data = MonitoringInfoEncodings.decodeInt64Distribution((ByteString)monitoringInfo.getPayload());
        DistributionResult result = DistributionResult.create((long)data.sum(), (long)data.count(), (long)data.min(), (long)data.max());
        return MetricResult.create((MetricKey)key, (Boolean)false, (Object)result);
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> extractCountersFromJobMetrics(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> monitoringInfoList) {
        return monitoringInfoList.stream().filter(item -> "beam:metrics:sum_int64:v1".equals(item.getType())).filter(item -> item.getLabelsMap().get(NAMESPACE_LABEL) != null).map(PortableMetrics::convertCounterMonitoringInfoToCounter).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long> convertCounterMonitoringInfoToCounter(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo counterMonInfo) {
        Map labelsMap = counterMonInfo.getLabelsMap();
        MetricKey key = MetricKey.create((String)((String)labelsMap.get(STEP_NAME_LABEL)), (MetricName)MetricName.named((String)((String)labelsMap.get(NAMESPACE_LABEL)), (String)((String)labelsMap.get(METRIC_NAME_LABEL))));
        return MetricResult.create((MetricKey)key, (Boolean)false, (Object)MonitoringInfoEncodings.decodeInt64Counter((ByteString)counterMonInfo.getPayload()));
    }
}

