/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.portability.testing;

import java.io.IOException;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.runners.portability.PortableRunner;
import org.apache.beam.runners.portability.testing.TestPortablePipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestPortableRunner
extends PipelineRunner<PipelineResult> {
    private final @UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options;

    private TestPortableRunner(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        this.options = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized TestPortableRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TestPortableRunner((PortablePipelineOptions)options.as(PortablePipelineOptions.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        String jobServerHostPort;
        JobServerDriver jobServerDriver;
        TestPortablePipelineOptions testPortablePipelineOptions = (TestPortablePipelineOptions)this.options.as(TestPortablePipelineOptions.class);
        Class<JobServerDriver> jobServerDriverClass = testPortablePipelineOptions.getJobServerDriver();
        String[] parameters = testPortablePipelineOptions.getJobServerConfig();
        try {
            jobServerDriver = (JobServerDriver)InstanceBuilder.ofType(jobServerDriverClass).fromFactoryMethod("fromParams").withArg(String[].class, (Object)parameters).build();
            jobServerHostPort = jobServerDriver.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start job server", e);
        }
        try {
            PortablePipelineOptions portableOptions = (PortablePipelineOptions)this.options.as(PortablePipelineOptions.class);
            portableOptions.setRunner(PortableRunner.class);
            portableOptions.setJobEndpoint(jobServerHostPort);
            PortableRunner runner = PortableRunner.fromOptions((PipelineOptions)portableOptions);
            PipelineResult result = runner.run(pipeline);
            MatcherAssert.assertThat((String)"Pipeline did not succeed.", (Object)result.waitUntilFinish(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
            PipelineResult pipelineResult = result;
            return pipelineResult;
        }
        finally {
            jobServerDriver.stop();
        }
    }
}

