/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.portability.testing;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.beam.runners.portability.PortableRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsRegistrar;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.runners.PipelineRunnerRegistrar;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestUniversalRunner
extends PipelineRunner<PipelineResult> {
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;

    private TestUniversalRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.options = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized TestUniversalRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TestUniversalRunner(options);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        Options testOptions = (Options)this.options.as(Options.class);
        if (testOptions.getLocalJobServicePortFile() != null) {
            String localServicePortFilePath = testOptions.getLocalJobServicePortFile();
            try {
                testOptions.setJobEndpoint("localhost:" + new String(Files.readAllBytes(Paths.get(localServicePortFilePath, new String[0])), StandardCharsets.UTF_8).trim());
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading local job service port file %s", localServicePortFilePath), e);
            }
        }
        PortablePipelineOptions portableOptions = (PortablePipelineOptions)this.options.as(PortablePipelineOptions.class);
        portableOptions.setRunner(PortableRunner.class);
        PortableRunner runner = PortableRunner.fromOptions((PipelineOptions)portableOptions);
        PipelineResult result = runner.run(pipeline);
        MatcherAssert.assertThat((String)"Pipeline did not succeed.", (Object)result.waitUntilFinish(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        return result;
    }

    @AutoService(value={PipelineRunnerRegistrar.class})
    public static class RunnerRegistrar
    implements PipelineRunnerRegistrar {
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> getPipelineRunners() {
            return ImmutableList.of(TestUniversalRunner.class);
        }
    }

    @AutoService(value={PipelineOptionsRegistrar.class})
    public static class OptionsRegistrar
    implements PipelineOptionsRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> getPipelineOptions() {
            return ImmutableList.of(Options.class);
        }
    }

    public static interface Options
    extends TestPipelineOptions,
    PortablePipelineOptions {
        @Description(value="File containing local job service port.")
        public @UnknownKeyFor @NonNull @Initialized String getLocalJobServicePortFile();

        public void setLocalJobServicePortFile(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

