/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import java.util.Optional;
import org.apache.beam.runners.prism.PrismArtifactResolver;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.util.construction.ArtifactResolver;
import org.apache.beam.sdk.util.construction.SdkComponents;

final class AutoValue_PrismArtifactResolver
extends PrismArtifactResolver {
    private final ArtifactResolver delegate;
    private final Pipeline pipeline;
    private final SdkComponents sdkComponents;

    private AutoValue_PrismArtifactResolver(ArtifactResolver delegate, Pipeline pipeline, SdkComponents sdkComponents) {
        this.delegate = delegate;
        this.pipeline = pipeline;
        this.sdkComponents = sdkComponents;
    }

    @Override
    ArtifactResolver getDelegate() {
        return this.delegate;
    }

    @Override
    Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    SdkComponents getSdkComponents() {
        return this.sdkComponents;
    }

    public String toString() {
        return "PrismArtifactResolver{delegate=" + this.delegate + ", pipeline=" + this.pipeline + ", sdkComponents=" + this.sdkComponents + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrismArtifactResolver) {
            PrismArtifactResolver that = (PrismArtifactResolver)o;
            return this.delegate.equals(that.getDelegate()) && this.pipeline.equals(that.getPipeline()) && this.sdkComponents.equals(that.getSdkComponents());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.delegate.hashCode();
        h$ *= 1000003;
        h$ ^= this.pipeline.hashCode();
        h$ *= 1000003;
        return h$ ^= this.sdkComponents.hashCode();
    }

    static final class Builder
    extends PrismArtifactResolver.Builder {
        private ArtifactResolver delegate;
        private Pipeline pipeline;
        private SdkComponents sdkComponents;

        Builder() {
        }

        @Override
        PrismArtifactResolver.Builder setDelegate(ArtifactResolver delegate) {
            if (delegate == null) {
                throw new NullPointerException("Null delegate");
            }
            this.delegate = delegate;
            return this;
        }

        @Override
        Optional<ArtifactResolver> getDelegate() {
            if (this.delegate == null) {
                return Optional.empty();
            }
            return Optional.of(this.delegate);
        }

        @Override
        PrismArtifactResolver.Builder setPipeline(Pipeline pipeline) {
            if (pipeline == null) {
                throw new NullPointerException("Null pipeline");
            }
            this.pipeline = pipeline;
            return this;
        }

        @Override
        Optional<Pipeline> getPipeline() {
            if (this.pipeline == null) {
                return Optional.empty();
            }
            return Optional.of(this.pipeline);
        }

        @Override
        PrismArtifactResolver.Builder setSdkComponents(SdkComponents sdkComponents) {
            if (sdkComponents == null) {
                throw new NullPointerException("Null sdkComponents");
            }
            this.sdkComponents = sdkComponents;
            return this;
        }

        @Override
        Optional<SdkComponents> getSdkComponents() {
            if (this.sdkComponents == null) {
                return Optional.empty();
            }
            return Optional.of(this.sdkComponents);
        }

        @Override
        PrismArtifactResolver autoBuild() {
            if (this.delegate == null || this.pipeline == null || this.sdkComponents == null) {
                StringBuilder missing = new StringBuilder();
                if (this.delegate == null) {
                    missing.append(" delegate");
                }
                if (this.pipeline == null) {
                    missing.append(" pipeline");
                }
                if (this.sdkComponents == null) {
                    missing.append(" sdkComponents");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PrismArtifactResolver(this.delegate, this.pipeline, this.sdkComponents);
        }
    }
}

