/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import java.util.List;
import java.util.Optional;
import org.apache.beam.runners.prism.PrismExecutor;

final class AutoValue_PrismExecutor
extends PrismExecutor {
    private final String command;
    private final List<String> arguments;

    private AutoValue_PrismExecutor(String command, List<String> arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    @Override
    String getCommand() {
        return this.command;
    }

    @Override
    List<String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "PrismExecutor{command=" + this.command + ", arguments=" + this.arguments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrismExecutor) {
            PrismExecutor that = (PrismExecutor)o;
            return this.command.equals(that.getCommand()) && this.arguments.equals(that.getArguments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.command.hashCode();
        h$ *= 1000003;
        return h$ ^= this.arguments.hashCode();
    }

    static final class Builder
    extends PrismExecutor.Builder {
        private String command;
        private List<String> arguments;

        Builder() {
        }

        @Override
        PrismExecutor.Builder setCommand(String command) {
            if (command == null) {
                throw new NullPointerException("Null command");
            }
            this.command = command;
            return this;
        }

        @Override
        PrismExecutor.Builder setArguments(List<String> arguments) {
            if (arguments == null) {
                throw new NullPointerException("Null arguments");
            }
            this.arguments = arguments;
            return this;
        }

        @Override
        Optional<List<String>> getArguments() {
            if (this.arguments == null) {
                return Optional.empty();
            }
            return Optional.of(this.arguments);
        }

        @Override
        PrismExecutor autoBuild() {
            if (this.command == null || this.arguments == null) {
                StringBuilder missing = new StringBuilder();
                if (this.command == null) {
                    missing.append(" command");
                }
                if (this.arguments == null) {
                    missing.append(" arguments");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PrismExecutor(this.command, this.arguments);
        }
    }
}

