/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import java.util.Optional;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.runners.prism.PrismJobManager;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannel;
import org.joda.time.Duration;

final class AutoValue_PrismJobManager
extends PrismJobManager {
    private final String endpoint;
    private final Duration timeout;
    private final ManagedChannel managedChannel;
    private final JobServiceGrpc.JobServiceBlockingStub blockingStub;

    private AutoValue_PrismJobManager(String endpoint, Duration timeout, ManagedChannel managedChannel, JobServiceGrpc.JobServiceBlockingStub blockingStub) {
        this.endpoint = endpoint;
        this.timeout = timeout;
        this.managedChannel = managedChannel;
        this.blockingStub = blockingStub;
    }

    @Override
    String getEndpoint() {
        return this.endpoint;
    }

    @Override
    Duration getTimeout() {
        return this.timeout;
    }

    @Override
    ManagedChannel getManagedChannel() {
        return this.managedChannel;
    }

    @Override
    JobServiceGrpc.JobServiceBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    public String toString() {
        return "PrismJobManager{endpoint=" + this.endpoint + ", timeout=" + this.timeout + ", managedChannel=" + this.managedChannel + ", blockingStub=" + this.blockingStub + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrismJobManager) {
            PrismJobManager that = (PrismJobManager)o;
            return this.endpoint.equals(that.getEndpoint()) && this.timeout.equals((Object)that.getTimeout()) && this.managedChannel.equals(that.getManagedChannel()) && this.blockingStub.equals(that.getBlockingStub());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.endpoint.hashCode();
        h$ *= 1000003;
        h$ ^= this.timeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.managedChannel.hashCode();
        h$ *= 1000003;
        return h$ ^= this.blockingStub.hashCode();
    }

    static final class Builder
    extends PrismJobManager.Builder {
        private String endpoint;
        private Duration timeout;
        private ManagedChannel managedChannel;
        private JobServiceGrpc.JobServiceBlockingStub blockingStub;

        Builder() {
        }

        @Override
        PrismJobManager.Builder setEndpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("Null endpoint");
            }
            this.endpoint = endpoint;
            return this;
        }

        @Override
        Optional<String> getEndpoint() {
            if (this.endpoint == null) {
                return Optional.empty();
            }
            return Optional.of(this.endpoint);
        }

        @Override
        PrismJobManager.Builder setTimeout(Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("Null timeout");
            }
            this.timeout = timeout;
            return this;
        }

        @Override
        Optional<Duration> getTimeout() {
            if (this.timeout == null) {
                return Optional.empty();
            }
            return Optional.of(this.timeout);
        }

        @Override
        PrismJobManager.Builder setManagedChannel(ManagedChannel managedChannel) {
            if (managedChannel == null) {
                throw new NullPointerException("Null managedChannel");
            }
            this.managedChannel = managedChannel;
            return this;
        }

        @Override
        Optional<ManagedChannel> getManagedChannel() {
            if (this.managedChannel == null) {
                return Optional.empty();
            }
            return Optional.of(this.managedChannel);
        }

        @Override
        PrismJobManager.Builder setBlockingStub(JobServiceGrpc.JobServiceBlockingStub blockingStub) {
            if (blockingStub == null) {
                throw new NullPointerException("Null blockingStub");
            }
            this.blockingStub = blockingStub;
            return this;
        }

        @Override
        Optional<JobServiceGrpc.JobServiceBlockingStub> getBlockingStub() {
            if (this.blockingStub == null) {
                return Optional.empty();
            }
            return Optional.of(this.blockingStub);
        }

        @Override
        PrismJobManager autoBuild() {
            if (this.endpoint == null || this.timeout == null || this.managedChannel == null || this.blockingStub == null) {
                StringBuilder missing = new StringBuilder();
                if (this.endpoint == null) {
                    missing.append(" endpoint");
                }
                if (this.timeout == null) {
                    missing.append(" timeout");
                }
                if (this.managedChannel == null) {
                    missing.append(" managedChannel");
                }
                if (this.blockingStub == null) {
                    missing.append(" blockingStub");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PrismJobManager(this.endpoint, this.timeout, this.managedChannel, this.blockingStub);
        }
    }
}

