/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import com.google.auto.value.AutoValue;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.ArtifactStagingServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.artifact.ArtifactStagingService;
import org.apache.beam.runners.prism.AutoValue_PrismArtifactStager;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class PrismArtifactStager
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PrismArtifactStager.class);

    PrismArtifactStager() {
    }

    static @UnknownKeyFor @NonNull @Initialized PrismArtifactStager of(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PrepareJobResponse prepareJobResponse) {
        return PrismArtifactStager.of(prepareJobResponse.getArtifactStagingEndpoint().getUrl(), prepareJobResponse.getStagingSessionToken());
    }

    static @UnknownKeyFor @NonNull @Initialized PrismArtifactStager of(@UnknownKeyFor @NonNull @Initialized String stagingEndpoint, @UnknownKeyFor @NonNull @Initialized String stagingSessionToken) {
        return PrismArtifactStager.builder().setStagingEndpoint(stagingEndpoint).setStagingSessionToken(stagingSessionToken).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PrismArtifactStager.Builder();
    }

    void stage() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        LOG.info("staging artifacts at {}", (Object)this.getStagingEndpoint());
        ArtifactStagingService.offer((ArtifactRetrievalService)this.getRetrievalService(), (ArtifactStagingServiceGrpc.ArtifactStagingServiceStub)this.getStagingServiceStub(), (String)this.getStagingSessionToken());
    }

    abstract @UnknownKeyFor @NonNull @Initialized String getStagingEndpoint();

    abstract @UnknownKeyFor @NonNull @Initialized String getStagingSessionToken();

    abstract @UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService getRetrievalService();

    abstract @UnknownKeyFor @NonNull @Initialized ManagedChannel getManagedChannel();

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ArtifactStagingServiceGrpc.ArtifactStagingServiceStub getStagingServiceStub();

    @Override
    public void close() {
        LOG.info("shutting down {}", PrismArtifactStager.class);
        this.getRetrievalService().close();
        this.getManagedChannel().shutdown();
        try {
            this.getManagedChannel().awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStagingEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getStagingEndpoint();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStagingSessionToken(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRetrievalService(@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> getRetrievalService();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setManagedChannel(@UnknownKeyFor @NonNull @Initialized ManagedChannel var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ManagedChannel> getManagedChannel();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStagingServiceStub(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ArtifactStagingServiceGrpc.ArtifactStagingServiceStub var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ArtifactStagingServiceGrpc.ArtifactStagingServiceStub> getStagingServiceStub();

        abstract @UnknownKeyFor @NonNull @Initialized PrismArtifactStager autoBuild();

        final @UnknownKeyFor @NonNull @Initialized PrismArtifactStager build() {
            Preconditions.checkState((boolean)this.getStagingEndpoint().isPresent(), (Object)"missing staging endpoint");
            ManagedChannelFactory channelFactory = ManagedChannelFactory.createDefault();
            if (!this.getManagedChannel().isPresent()) {
                Endpoints.ApiServiceDescriptor descriptor = Endpoints.ApiServiceDescriptor.newBuilder().setUrl(this.getStagingEndpoint().get()).build();
                this.setManagedChannel(channelFactory.forDescriptor(descriptor));
            }
            if (!this.getStagingServiceStub().isPresent()) {
                this.setStagingServiceStub(ArtifactStagingServiceGrpc.newStub((Channel)((Channel)this.getManagedChannel().get())));
            }
            if (!this.getRetrievalService().isPresent()) {
                this.setRetrievalService(new ArtifactRetrievalService());
            }
            return this.autoBuild();
        }
    }
}

