/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.prism.AutoValue_PrismExecutor;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class PrismExecutor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PrismExecutor.class);
    static final @UnknownKeyFor @NonNull @Initialized String IDLE_SHUTDOWN_TIMEOUT = "-idle_shutdown_timeout=%s";
    static final @UnknownKeyFor @NonNull @Initialized String JOB_PORT_FLAG_TEMPLATE = "-job_port=%s";
    static final @UnknownKeyFor @NonNull @Initialized String SERVE_HTTP_FLAG_TEMPLATE = "-serve_http=%s";
    protected @MonotonicNonNull @UnknownKeyFor @Initialized Process process;
    protected @UnknownKeyFor @NonNull @Initialized ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @MonotonicNonNull @UnknownKeyFor @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> future = null;

    PrismExecutor() {
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PrismExecutor.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized String getCommand();

    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getArguments();

    void stop() {
        LOG.info("Stopping Prism...");
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.executorService.shutdown();
        try {
            boolean bl = this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.process == null) {
            return;
        }
        if (!this.process.isAlive()) {
            return;
        }
        this.process.destroy();
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean isAlive() {
        if (this.process == null) {
            return false;
        }
        return this.process.isAlive();
    }

    void execute() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.execute(this.createProcessBuilder().inheritIO());
    }

    void execute(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.execute(this.createProcessBuilder().redirectErrorStream(true));
        this.future = this.executorService.submit(() -> {
            try {
                ByteStreams.copy((InputStream)((Process)Preconditions.checkStateNotNull((Object)this.process)).getInputStream(), (OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    void execute(@UnknownKeyFor @NonNull @Initialized File file) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.execute(this.createProcessBuilder().redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(file)));
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized ProcessBuilder processBuilder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.process = processBuilder.start();
        LOG.info("started {}", (Object)String.join((CharSequence)" ", this.getCommandWithArguments()));
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getCommandWithArguments() {
        ArrayList<String> commandWithArguments = new ArrayList<String>();
        commandWithArguments.add(this.getCommand());
        commandWithArguments.addAll(this.getArguments());
        return commandWithArguments;
    }

    private @UnknownKeyFor @NonNull @Initialized ProcessBuilder createProcessBuilder() {
        return new ProcessBuilder(this.getCommandWithArguments());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommand(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setArguments(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getArguments();

        abstract @UnknownKeyFor @NonNull @Initialized PrismExecutor autoBuild();

        final @UnknownKeyFor @NonNull @Initialized PrismExecutor build() {
            if (!this.getArguments().isPresent()) {
                this.setArguments(Collections.emptyList());
            }
            return this.autoBuild();
        }
    }
}

