/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import com.google.auto.value.AutoValue;
import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.prism.AutoValue_PrismJobManager;
import org.apache.beam.runners.prism.StateListener;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
abstract class PrismJobManager
implements StateListener,
Closeable {
    PrismJobManager() {
    }

    static @UnknownKeyFor @NonNull @Initialized PrismJobManager of(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        return PrismJobManager.builder().setEndpoint(options.getJobEndpoint()).setTimeout(Duration.standardSeconds((long)options.getJobServerTimeout())).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PrismJobManager.Builder();
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PrepareJobResponse prepare(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PrepareJobRequest request) {
        return this.getBlockingStub().prepare(request);
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.RunJobResponse run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.RunJobRequest request) {
        return this.getBlockingStub().run(request);
    }

    abstract @UnknownKeyFor @NonNull @Initialized String getEndpoint();

    abstract @UnknownKeyFor @NonNull @Initialized Duration getTimeout();

    abstract @UnknownKeyFor @NonNull @Initialized ManagedChannel getManagedChannel();

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub getBlockingStub();

    @Override
    public void close() {
        if (this.isShutdown()) {
            return;
        }
        this.getManagedChannel().shutdown();
        try {
            this.getManagedChannel().awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean isShutdown() {
        return this.getManagedChannel().isShutdown();
    }

    @Override
    public void onStateChanged(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineResult.State state) {
        if (state.isTerminal()) {
            this.close();
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getEndpoint();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Duration> getTimeout();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setManagedChannel(@UnknownKeyFor @NonNull @Initialized ManagedChannel var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ManagedChannel> getManagedChannel();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setBlockingStub(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub> getBlockingStub();

        abstract @UnknownKeyFor @NonNull @Initialized PrismJobManager autoBuild();

        final @UnknownKeyFor @NonNull @Initialized PrismJobManager build() {
            Preconditions.checkState((boolean)this.getEndpoint().isPresent(), (Object)"endpoint is not set");
            Preconditions.checkState((boolean)this.getTimeout().isPresent(), (Object)"timeout is not set");
            if (!this.getManagedChannel().isPresent()) {
                ManagedChannelFactory channelFactory = ManagedChannelFactory.createDefault();
                this.setManagedChannel(channelFactory.forDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(this.getEndpoint().get()).build()));
            }
            if (!this.getBlockingStub().isPresent()) {
                this.setBlockingStub((JobServiceGrpc.JobServiceBlockingStub)((JobServiceGrpc.JobServiceBlockingStub)JobServiceGrpc.newBlockingStub((Channel)((Channel)this.getManagedChannel().get())).withDeadlineAfter(this.getTimeout().get().getMillis(), TimeUnit.MILLISECONDS)).withWaitForReady());
            }
            return this.autoBuild();
        }
    }
}

