/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.beam.runners.prism.PrismPipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PrismLocator {
    static final @UnknownKeyFor @NonNull @Initialized String OS_NAME_PROPERTY = "os.name";
    static final @UnknownKeyFor @NonNull @Initialized String ARCH_PROPERTY = "os.arch";
    static final @UnknownKeyFor @NonNull @Initialized String USER_HOME_PROPERTY = "user.home";
    private static final @UnknownKeyFor @NonNull @Initialized String ZIP_EXT = "zip";
    private static final @UnknownKeyFor @NonNull @Initialized ReleaseInfo RELEASE_INFO = ReleaseInfo.getReleaseInfo();
    private static final @UnknownKeyFor @NonNull @Initialized String PRISM_BIN_PATH = ".apache_beam/cache/prism/bin";
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PosixFilePermission> PERMS = PosixFilePermissions.fromString("rwxr-xr-x");
    private static final @UnknownKeyFor @NonNull @Initialized String GITHUB_DOWNLOAD_PREFIX = "https://github.com/apache/beam/releases/download";
    private static final @UnknownKeyFor @NonNull @Initialized String GITHUB_TAG_PREFIX = "https://github.com/apache/beam/releases/tag";
    private final @UnknownKeyFor @NonNull @Initialized PrismPipelineOptions options;

    PrismLocator(@UnknownKeyFor @NonNull @Initialized PrismPipelineOptions options) {
        this.options = options;
    }

    @UnknownKeyFor @NonNull @Initialized String resolve() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String from = String.format("%s/v%s/%s.zip", GITHUB_DOWNLOAD_PREFIX, this.getSDKVersion(), this.buildFileName());
        if (!Strings.isNullOrEmpty((String)this.options.getPrismLocation())) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.options.getPrismLocation().startsWith(GITHUB_TAG_PREFIX) ? 1 : 0) != 0, (String)"Provided --prismLocation URL is not an Apache Beam Github Release page URL or download URL: ", (Object)from);
            from = this.options.getPrismLocation();
        }
        String fromFileName = PrismLocator.getNameWithoutExtension(from);
        Path to = Paths.get(PrismLocator.userHome(), PRISM_BIN_PATH, fromFileName);
        if (Files.exists(to, new LinkOption[0])) {
            return to.toString();
        }
        PrismLocator.createDirectoryIfNeeded(to);
        if (from.startsWith("http")) {
            String result = this.resolve(new URL(from), to);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)Files.exists(to, new LinkOption[0]), (String)"Resolved location does not exist: %s", (Object)result);
            return result;
        }
        String result = this.resolve(Paths.get(from, new String[0]), to);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)Files.exists(to, new LinkOption[0]), (String)"Resolved location does not exist: %s", (Object)result);
        return result;
    }

    static @UnknownKeyFor @NonNull @Initialized Path prismBinDirectory() {
        return Paths.get(PrismLocator.userHome(), PRISM_BIN_PATH);
    }

    private @UnknownKeyFor @NonNull @Initialized String resolve(@UnknownKeyFor @NonNull @Initialized URL from, @UnknownKeyFor @NonNull @Initialized Path to) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BiConsumer<URL, Path> downloadFn = PrismLocator::download;
        if (from.getPath().endsWith(ZIP_EXT)) {
            downloadFn = PrismLocator::unzip;
        }
        downloadFn.accept(from, to);
        Files.setPosixFilePermissions(to, PERMS);
        return to.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String resolve(@UnknownKeyFor @NonNull @Initialized Path from, @UnknownKeyFor @NonNull @Initialized Path to) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BiConsumer<InputStream, Path> copyFn = PrismLocator::copy;
        if (from.endsWith(ZIP_EXT)) {
            copyFn = PrismLocator::unzip;
        }
        copyFn.accept(from.toUri().toURL().openStream(), to);
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            ByteStreams.copy((InputStream)from.toUri().toURL().openStream(), (OutputStream)out);
        }
        Files.setPosixFilePermissions(to, PERMS);
        return to.toString();
    }

    @UnknownKeyFor @NonNull @Initialized String buildFileName() {
        String version = this.getSDKVersion();
        return String.format("apache_beam-v%s-prism-%s-%s", version, PrismLocator.os(), PrismLocator.arch());
    }

    private static void unzip(@UnknownKeyFor @NonNull @Initialized URL from, @UnknownKeyFor @NonNull @Initialized Path to) {
        try {
            PrismLocator.unzip(from.openStream(), to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void unzip(@UnknownKeyFor @NonNull @Initialized InputStream from, @UnknownKeyFor @NonNull @Initialized Path to) {
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            ZipInputStream zis = new ZipInputStream(from);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                InputStream in = ByteStreams.limit((InputStream)zis, (long)entry.getSize());
                ByteStreams.copy((InputStream)in, (OutputStream)out);
                entry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copy(@UnknownKeyFor @NonNull @Initialized InputStream from, @UnknownKeyFor @NonNull @Initialized Path to) {
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            ByteStreams.copy((InputStream)from, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void download(@UnknownKeyFor @NonNull @Initialized URL from, @UnknownKeyFor @NonNull @Initialized Path to) {
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            ByteStreams.copy((InputStream)from.openStream(), (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String getNameWithoutExtension(@UnknownKeyFor @NonNull @Initialized String path) {
        return org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files.getNameWithoutExtension((String)path);
    }

    private @UnknownKeyFor @NonNull @Initialized String getSDKVersion() {
        if (Strings.isNullOrEmpty((String)this.options.getPrismVersionOverride())) {
            return RELEASE_INFO.getSdkVersion();
        }
        return this.options.getPrismVersionOverride();
    }

    private static @UnknownKeyFor @NonNull @Initialized String os() {
        String result = PrismLocator.mustGetPropertyAsLowerCase(OS_NAME_PROPERTY);
        if (result.contains("mac")) {
            return "darwin";
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized String arch() {
        String result = PrismLocator.mustGetPropertyAsLowerCase(ARCH_PROPERTY);
        if (result.contains("aarch")) {
            return "arm64";
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized String userHome() {
        return PrismLocator.mustGetPropertyAsLowerCase(USER_HOME_PROPERTY);
    }

    private static @UnknownKeyFor @NonNull @Initialized String mustGetPropertyAsLowerCase(@UnknownKeyFor @NonNull @Initialized String name) {
        return ((String)Preconditions.checkStateNotNull((Object)System.getProperty(name), (Object)("System property: " + name + " not set"))).toLowerCase();
    }

    private static void createDirectoryIfNeeded(@UnknownKeyFor @NonNull @Initialized Path path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Path parent = path.getParent();
        if (parent == null) {
            return;
        }
        Files.createDirectories(parent, new FileAttribute[0]);
    }
}

