/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface PrismPipelineOptions
extends PortablePipelineOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String JOB_PORT_FLAG_NAME = "job_port";

    @Description(value="Path or URL to a prism binary, or zipped binary for the current platform (Operating System and Architecture). May also be an Apache Beam Github Release page URL, with a matching --prismVersionOverride set. This option overrides all others for finding a prism binary.")
    public @UnknownKeyFor @NonNull @Initialized String getPrismLocation();

    public void setPrismLocation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Override the SDK's version for deriving the Github Release URLs for downloading a zipped prism binary, for the current platform. If set to a Github Release page URL, then it will use that release page as a base when constructing the download URL.")
    public @UnknownKeyFor @NonNull @Initialized String getPrismVersionOverride();

    public void setPrismVersionOverride(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Enable or disable Prism Web UI")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableWebUI();

    public void setEnableWebUI(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Duration, represented as a String, that prism will wait for a new job before shutting itself down. Negative durations disable auto shutdown. Valid time units are \"ns\", \"us\" (or \"\u00b5s\"), \"ms\", \"s\", \"m\", \"h\".")
    @Default.String(value="5m")
    public @UnknownKeyFor @NonNull @Initialized String getIdleShutdownTimeout();

    public void setIdleShutdownTimeout(@UnknownKeyFor @NonNull @Initialized String var1);
}

