/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.runners.prism.AutoValue_StateWatcher;
import org.apache.beam.runners.prism.StateListener;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.InsecureChannelCredentials;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.NettyChannelBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.net.HostAndPort;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class StateWatcher
implements AutoCloseable {
    private @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineResult.State> latestState = Optional.empty();

    StateWatcher() {
    }

    static @UnknownKeyFor @NonNull @Initialized StateWatcher insecure(@UnknownKeyFor @NonNull @Initialized String endpoint, StateListener ... listeners) {
        return StateWatcher.builder().setEndpoint(HostAndPort.fromString((String)endpoint)).setCredentials(InsecureChannelCredentials.create()).setListeners(Arrays.asList(listeners)).build();
    }

    void watch(@UnknownKeyFor @NonNull @Initialized String jobId) {
        JobApi.GetJobStateRequest request = JobApi.GetJobStateRequest.newBuilder().setJobId(jobId).build();
        Iterator iterator = this.getJobServiceBlockingStub().getStateStream(request);
        while (iterator.hasNext()) {
            JobApi.JobStateEvent event = (JobApi.JobStateEvent)iterator.next();
            PipelineResult.State state = PipelineResult.State.valueOf((String)event.getState().name());
            this.publish(state);
        }
    }

    private void publish(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineResult.State state) {
        if (this.latestState.isPresent() && this.latestState.get().equals((Object)state)) {
            return;
        }
        this.latestState = Optional.of(state);
        for (StateListener listener : this.getListeners()) {
            listener.onStateChanged(state);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_StateWatcher.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized HostAndPort getEndpoint();

    abstract @UnknownKeyFor @NonNull @Initialized ChannelCredentials getCredentials();

    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized StateListener> getListeners();

    abstract @UnknownKeyFor @NonNull @Initialized ManagedChannel getManagedChannel();

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub getJobServiceBlockingStub();

    @Override
    public void close() {
        this.getManagedChannel().shutdown();
        try {
            this.getManagedChannel().awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEndpoint(@UnknownKeyFor @NonNull @Initialized HostAndPort var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized HostAndPort> getEndpoint();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCredentials(@UnknownKeyFor @NonNull @Initialized ChannelCredentials var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ChannelCredentials> getCredentials();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setListeners(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized StateListener> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setManagedChannel(@UnknownKeyFor @NonNull @Initialized ManagedChannel var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setJobServiceBlockingStub(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized JobServiceGrpc.JobServiceBlockingStub var1);

        abstract @UnknownKeyFor @NonNull @Initialized StateWatcher autoBuild();

        final @UnknownKeyFor @NonNull @Initialized StateWatcher build() {
            if (!this.getEndpoint().isPresent()) {
                throw new IllegalStateException("missing endpoint");
            }
            if (!this.getCredentials().isPresent()) {
                throw new IllegalStateException("missing credentials");
            }
            HostAndPort endpoint = this.getEndpoint().get();
            ManagedChannel channel = NettyChannelBuilder.forAddress((String)endpoint.getHost(), (int)endpoint.getPort(), (ChannelCredentials)this.getCredentials().get()).build();
            this.setManagedChannel(channel);
            this.setJobServiceBlockingStub(JobServiceGrpc.newBlockingStub((Channel)channel));
            return this.autoBuild();
        }
    }
}

