/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import java.util.function.Supplier;
import org.apache.beam.runners.prism.PrismPipelineResult;
import org.apache.beam.runners.prism.PrismRunner;
import org.apache.beam.runners.prism.TestPrismPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;

public class TestPrismRunner
extends PipelineRunner<PipelineResult> {
    private final @UnknownKeyFor @NonNull @Initialized PrismRunner internal;
    private final @UnknownKeyFor @NonNull @Initialized TestPrismPipelineOptions prismPipelineOptions;

    public static @UnknownKeyFor @NonNull @Initialized TestPrismRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        TestPrismPipelineOptions prismPipelineOptions = (TestPrismPipelineOptions)options.as(TestPrismPipelineOptions.class);
        PrismRunner delegate = PrismRunner.fromOptions(options);
        return new TestPrismRunner(delegate, prismPipelineOptions);
    }

    private TestPrismRunner(@UnknownKeyFor @NonNull @Initialized PrismRunner internal, @UnknownKeyFor @NonNull @Initialized TestPrismPipelineOptions options) {
        this.internal = internal;
        this.prismPipelineOptions = options;
    }

    @UnknownKeyFor @NonNull @Initialized TestPrismPipelineOptions getTestPrismPipelineOptions() {
        return this.prismPipelineOptions;
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PrismPipelineResult result = (PrismPipelineResult)this.internal.run(pipeline);
        try {
            PipelineResult.State state = this.getWaitUntilFinishRunnable(result).get();
            MatcherAssert.assertThat((String)"Pipeline did not succeed. Check Prism logs for further details.", (Object)state, (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        }
        catch (RuntimeException e) {
            result.getCleanup().run();
            throw new AssertionError((Object)e);
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized Supplier<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State> getWaitUntilFinishRunnable(@UnknownKeyFor @NonNull @Initialized PipelineResult result) {
        if (this.prismPipelineOptions.getTestTimeoutSeconds() != null) {
            Long testTimeoutSeconds = (Long)Preconditions.checkStateNotNull((Object)this.prismPipelineOptions.getTestTimeoutSeconds());
            return () -> result.waitUntilFinish(Duration.standardSeconds((long)testTimeoutSeconds));
        }
        return () -> ((PipelineResult)result).waitUntilFinish();
    }
}

