/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.prism;

import org.apache.beam.fn.harness.ExternalWorkerService;
import org.apache.beam.runners.prism.StateListener;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerService
implements StateListener {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WorkerService.class);
    private final @UnknownKeyFor @NonNull @Initialized ExternalWorkerService worker;
    private @MonotonicNonNull @UnknownKeyFor @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ExternalWorkerService> server;

    WorkerService(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        this.worker = new ExternalWorkerService((PipelineOptions)options);
    }

    void start() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.server != null && !this.server.getServer().isShutdown()) {
            return;
        }
        this.server = this.worker.start();
        LOG.info("Starting worker service at {}", (Object)this.getApiServiceDescriptorUrl());
    }

    @UnknownKeyFor @NonNull @Initialized boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return !this.server.getServer().isShutdown();
    }

    @UnknownKeyFor @NonNull @Initialized String getApiServiceDescriptorUrl() {
        return ((GrpcFnServer)Preconditions.checkStateNotNull(this.server, (Object)"worker service not started")).getApiServiceDescriptor().getUrl();
    }

    @UnknownKeyFor @NonNull @Initialized PortablePipelineOptions updateDefaultEnvironmentConfig(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        options.setDefaultEnvironmentConfig(this.getApiServiceDescriptorUrl());
        return options;
    }

    @Override
    public void onStateChanged(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineResult.State state) {
        if (state.isTerminal()) {
            this.stop();
        }
    }

    void stop() {
        if (this.server == null || this.server.getServer().isShutdown()) {
            return;
        }
        LOG.info("Stopping worker service at {}", (Object)this.getApiServiceDescriptorUrl());
        try {
            this.server.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

