/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class WindowAssignTranslatorBatch<@UnknownKeyFor T>
extends TransformTranslator<PCollection<T>, PCollection<T>, Window.Assign<T>> {
    WindowAssignTranslatorBatch() {
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        WindowFn windowFn = transform.getWindowFn();
        PCollection input = (PCollection)cxt.getInput();
        Dataset inputDataset = cxt.getDataset(input);
        if (windowFn == null || this.skipAssignWindows(windowFn, input)) {
            cxt.putDataset((PCollection)cxt.getOutput(), inputDataset);
        } else {
            Dataset outputDataset = inputDataset.map(WindowAssignTranslatorBatch.assignWindows(windowFn), cxt.windowedEncoder(input.getCoder(), windowFn.windowCoder()));
            cxt.putDataset((PCollection)cxt.getOutput(), outputDataset);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean skipAssignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> newFn, @UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        WindowFn currentFn = input.getWindowingStrategy().getWindowFn();
        return currentFn instanceof GlobalWindows && newFn instanceof GlobalWindows;
    }

    private static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized MapFunction<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>, @UnknownKeyFor @NonNull @Initialized WindowedValue<T>> assignWindows(@UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn) {
        return (MapFunction & Serializable)value -> {
            final BoundedWindow window = WindowAssignTranslatorBatch.getOnlyWindow(value);
            final Object element = value.getValue();
            final Instant timestamp = value.getTimestamp();
            WindowFn windowFn2 = windowFn;
            Objects.requireNonNull(windowFn2);
            Collection windows = windowFn.assignWindows(new WindowFn.AssignContext(windowFn2){

                public T element() {
                    return element;
                }

                public @NonNull @UnknownKeyFor @Initialized Instant timestamp() {
                    return timestamp;
                }

                public @NonNull @UnknownKeyFor @Initialized BoundedWindow window() {
                    return window;
                }
            });
            return WindowedValue.of((Object)element, (Instant)timestamp, (Collection)windows, (PaneInfo)value.getPane());
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized BoundedWindow getOnlyWindow(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> wv) {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)wv.getWindows());
    }
}

