/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.catalyst.SerializerBuildHelper;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.util.MutablePair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class EncoderHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized DataType OBJECT_TYPE = new ObjectType(Object.class);
    private static final @UnknownKeyFor @NonNull @Initialized DataType TUPLE2_TYPE = new ObjectType(Tuple2.class);
    private static final @UnknownKeyFor @NonNull @Initialized DataType WINDOWED_VALUE = new ObjectType(WindowedValue.class);
    private static final @UnknownKeyFor @NonNull @Initialized DataType KV_TYPE = new ObjectType(KV.class);
    private static final @UnknownKeyFor @NonNull @Initialized DataType MUTABLE_PAIR_TYPE = new ObjectType(MutablePair.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> PRIMITIV_TYPES = ImmutableSet.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, (Object[])new Class[]{Double.class});
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> DEFAULT_ENCODERS = new ConcurrentHashMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @Nullable @UnknownKeyFor @Initialized Encoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> ENCODER_FACTORY = cls -> {
        if (cls.equals(PaneInfo.class)) {
            return EncoderHelpers.paneInfoEncoder();
        }
        if (cls.equals(GlobalWindow.class)) {
            return EncoderHelpers.binaryEncoder(GlobalWindow.Coder.INSTANCE, false);
        }
        if (cls.equals(IntervalWindow.class)) {
            return EncoderHelpers.binaryEncoder(IntervalWindow.IntervalWindowCoder.of(), false);
        }
        if (cls.equals(Instant.class)) {
            return EncoderHelpers.instantEncoder();
        }
        if (cls.equals(String.class)) {
            return Encoders.STRING();
        }
        if (cls.equals(Boolean.class)) {
            return Encoders.BOOLEAN();
        }
        if (cls.equals(Integer.class)) {
            return Encoders.INT();
        }
        if (cls.equals(Long.class)) {
            return Encoders.LONG();
        }
        if (cls.equals(Float.class)) {
            return Encoders.FLOAT();
        }
        if (cls.equals(Double.class)) {
            return Encoders.DOUBLE();
        }
        if (cls.equals(BigDecimal.class)) {
            return Encoders.DECIMAL();
        }
        if (cls.equals(byte[].class)) {
            return Encoders.BINARY();
        }
        if (cls.equals(Byte.class)) {
            return Encoders.BYTE();
        }
        if (cls.equals(Short.class)) {
            return Encoders.SHORT();
        }
        return null;
    };

    private static <T> @Nullable @UnknownKeyFor @Initialized Encoder<T> getOrCreateDefaultEncoder(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> cls) {
        return DEFAULT_ENCODERS.computeIfAbsent(cls, ENCODER_FACTORY);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderOf(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> cls) {
        Encoder<? super T> enc = EncoderHelpers.getOrCreateDefaultEncoder(cls);
        if (enc == null) {
            throw new IllegalArgumentException("No default coder available for class " + cls);
        }
        return enc;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderFor(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Encoder<T> enc = EncoderHelpers.getOrCreateDefaultEncoder(coder.getEncodedTypeDescriptor().getRawType());
        return enc != null ? enc : EncoderHelpers.binaryEncoder(coder, true);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedValueEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T> value, @UnknownKeyFor @NonNull @Initialized Encoder<W> window) {
        Encoder<Instant> timestamp = EncoderHelpers.encoderOf(Instant.class);
        Encoder<PaneInfo> pane = EncoderHelpers.encoderOf(PaneInfo.class);
        Encoder<Collection<W>> windows = EncoderHelpers.collectionEncoder(window);
        Expression serializer = EncoderHelpers.serializeWindowedValue(EncoderHelpers.rootRef(WINDOWED_VALUE, true), value, timestamp, windows, pane);
        Expression deserializer = EncoderHelpers.deserializeWindowedValue(EncoderHelpers.rootCol(serializer.dataType()), value, timestamp, windows, pane);
        return EncoderFactory.create(serializer, deserializer, WindowedValue.class);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Integer, T>> oneOfEncoder(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Encoder<T>> encoders) {
        Expression serializer = EncoderHelpers.serializeOneOf(EncoderHelpers.rootRef(TUPLE2_TYPE, true), encoders);
        Expression deserializer = EncoderHelpers.deserializeOneOf(EncoderHelpers.rootCol(serializer.dataType()), encoders);
        return EncoderFactory.create(serializer, deserializer, Tuple2.class);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> kvEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<K> key, @UnknownKeyFor @NonNull @Initialized Encoder<V> value) {
        Expression serializer = EncoderHelpers.serializeKV(EncoderHelpers.rootRef(KV_TYPE, true), key, value);
        Expression deserializer = EncoderHelpers.deserializeKV(EncoderHelpers.rootCol(serializer.dataType()), key, value);
        return EncoderFactory.create(serializer, deserializer, KV.class);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Collection<T>> collectionEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return EncoderHelpers.collectionEncoder(enc, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Collection<T>> collectionEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        ObjectType type = new ObjectType(Collection.class);
        Expression serializer = EncoderHelpers.serializeSeq(EncoderHelpers.rootRef((DataType)type, true), enc, nullable);
        Expression deserializer = EncoderHelpers.deserializeSeq(EncoderHelpers.rootCol(serializer.dataType()), enc, nullable, true);
        return EncoderFactory.create(serializer, deserializer, Collection.class);
    }

    public static <MapT extends Map<K, V>, K, V> @UnknownKeyFor @NonNull @Initialized Encoder<MapT> mapEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<K> key, @UnknownKeyFor @NonNull @Initialized Encoder<V> value, @UnknownKeyFor @NonNull @Initialized Class<MapT> cls) {
        Expression serializer = EncoderHelpers.mapSerializer(EncoderHelpers.rootRef((DataType)new ObjectType(cls), true), key, value);
        Expression deserializer = EncoderHelpers.mapDeserializer(EncoderHelpers.rootCol(serializer.dataType()), key, value, cls);
        return EncoderFactory.create(serializer, deserializer, cls);
    }

    public static <T1, T2> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized MutablePair<T1, T2>> mutablePairEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T1> enc1, @UnknownKeyFor @NonNull @Initialized Encoder<T2> enc2) {
        Expression serializer = EncoderHelpers.serializeMutablePair(EncoderHelpers.rootRef(MUTABLE_PAIR_TYPE, true), enc1, enc2);
        Expression deserializer = EncoderHelpers.deserializeMutablePair(EncoderHelpers.rootCol(serializer.dataType()), enc1, enc2);
        return EncoderFactory.create(serializer, deserializer, MutablePair.class);
    }

    private static @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized PaneInfo> paneInfoEncoder() {
        ObjectType type = new ObjectType(PaneInfo.class);
        return EncoderFactory.create(EncoderFactory.invokeIfNotNull(Utils.class, "paneInfoToBytes", DataTypes.BinaryType, EncoderHelpers.rootRef((DataType)type, false)), EncoderFactory.invokeIfNotNull(Utils.class, "paneInfoFromBytes", (DataType)type, EncoderHelpers.rootCol(DataTypes.BinaryType)), PaneInfo.class);
    }

    private static @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Instant> instantEncoder() {
        ObjectType type = new ObjectType(Instant.class);
        Expression instant = EncoderHelpers.rootRef((DataType)type, true);
        Expression millis = EncoderHelpers.rootCol(DataTypes.LongType);
        return EncoderFactory.create(EncoderHelpers.nullSafe(instant, EncoderFactory.invoke(instant, "getMillis", DataTypes.LongType, false, new Expression[0])), EncoderHelpers.nullSafe(millis, EncoderFactory.invoke(Instant.class, "ofEpochMilli", (DataType)type, millis)), Instant.class);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> binaryEncoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        Literal litCoder = EncoderHelpers.lit(coder, Coder.class);
        return EncoderFactory.create(EncoderFactory.invokeIfNotNull(CoderHelpers.class, "toByteArray", DataTypes.BinaryType, new Expression[]{EncoderHelpers.rootRef(OBJECT_TYPE, nullable), litCoder}), EncoderFactory.invokeIfNotNull(CoderHelpers.class, "fromByteArray", OBJECT_TYPE, new Expression[]{EncoderHelpers.rootCol(DataTypes.BinaryType), litCoder}), coder.getEncodedTypeDescriptor().getRawType());
    }

    private static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Expression serializeWindowedValue(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> valueEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Instant> timestampEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Collection<W>> windowsEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized PaneInfo> paneEnc) {
        return EncoderHelpers.serializerObject(in, ScalaInterop.tuple("value", EncoderHelpers.serializeField(in, valueEnc, "getValue")), ScalaInterop.tuple("timestamp", EncoderHelpers.serializeField(in, timestampEnc, "getTimestamp")), ScalaInterop.tuple("windows", EncoderHelpers.serializeField(in, windowsEnc, "getWindows")), ScalaInterop.tuple("pane", EncoderHelpers.serializeField(in, paneEnc, "getPane")));
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression serializerObject(@UnknownKeyFor @NonNull @Initialized Expression in, Tuple2<String, Expression> ... fields) {
        return SerializerBuildHelper.createSerializerForObject((Expression)in, ScalaInterop.seqOf(fields));
    }

    private static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Expression deserializeWindowedValue(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> valueEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Instant> timestampEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Collection<W>> windowsEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized PaneInfo> paneEnc) {
        Expression value = EncoderHelpers.deserializeField(in, valueEnc, 0, "value");
        Expression windows = EncoderHelpers.deserializeField(in, windowsEnc, 2, "windows");
        Expression timestamp = EncoderHelpers.deserializeField(in, timestampEnc, 1, "timestamp");
        Expression pane = EncoderHelpers.deserializeField(in, paneEnc, 3, "pane");
        timestamp = EncoderHelpers.ifNotNull(timestamp, EncoderFactory.invoke(Utils.class, "maxTimestamp", timestamp.dataType(), windows));
        Expression[] fields = new Expression[]{value, timestamp, windows, pane};
        return EncoderHelpers.nullSafe(pane, EncoderFactory.invoke(WindowedValue.class, "of", WINDOWED_VALUE, fields));
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Expression serializeMutablePair(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<K> enc1, @UnknownKeyFor @NonNull @Initialized Encoder<V> enc2) {
        return EncoderHelpers.serializerObject(in, ScalaInterop.tuple("_1", EncoderHelpers.serializeField(in, enc1, "_1")), ScalaInterop.tuple("_2", EncoderHelpers.serializeField(in, enc2, "_2")));
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Expression deserializeMutablePair(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<K> enc1, @UnknownKeyFor @NonNull @Initialized Encoder<V> enc2) {
        Expression field1 = EncoderHelpers.deserializeField(in, enc1, 0, "_1");
        Expression field2 = EncoderHelpers.deserializeField(in, enc2, 1, "_2");
        return EncoderFactory.invoke(MutablePair.class, "apply", MUTABLE_PAIR_TYPE, field1, field2);
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Expression serializeKV(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<K> keyEnc, @UnknownKeyFor @NonNull @Initialized Encoder<V> valueEnc) {
        return EncoderHelpers.serializerObject(in, ScalaInterop.tuple("key", EncoderHelpers.serializeField(in, keyEnc, "getKey")), ScalaInterop.tuple("value", EncoderHelpers.serializeField(in, valueEnc, "getValue")));
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Expression deserializeKV(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<K> keyEnc, @UnknownKeyFor @NonNull @Initialized Encoder<V> valueEnc) {
        Expression key = EncoderHelpers.deserializeField(in, keyEnc, 0, "key");
        Expression value = EncoderHelpers.deserializeField(in, valueEnc, 1, "value");
        return EncoderFactory.invoke(KV.class, "of", KV_TYPE, key, value);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Expression serializeOneOf(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Encoder<T>> encoders) {
        Expression type = EncoderFactory.invoke(in, "_1", DataTypes.IntegerType, false, new Expression[0]);
        Expression[] args = new Expression[encoders.size() * 2];
        for (int i = 0; i < encoders.size(); ++i) {
            args[i * 2] = EncoderHelpers.lit(String.valueOf(i));
            args[i * 2 + 1] = EncoderHelpers.serializeOneOfField(in, type, encoders.get(i), i);
        }
        return new CreateNamedStruct(ScalaInterop.seqOf(args));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Expression deserializeOneOf(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Encoder<T>> encoders) {
        Expression[] args = new Expression[encoders.size()];
        for (int i = 0; i < encoders.size(); ++i) {
            args[i] = EncoderHelpers.deserializeOneOfField(in, encoders.get(i), i);
        }
        return new Coalesce(ScalaInterop.seqOf(args));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression serializeOneOfField(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Expression type, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized int typeIdx) {
        Expression litNull = EncoderHelpers.lit(null, EncoderHelpers.serializedType(enc));
        Expression value = EncoderFactory.invoke(in, "_2", EncoderHelpers.deserializedType(enc), false, new Expression[0]);
        return new If((Expression)new EqualTo(type, EncoderHelpers.lit(typeIdx)), EncoderHelpers.serialize(value, enc), litNull);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression deserializeOneOfField(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized int idx) {
        GetStructField field = new GetStructField(in, idx, Option.empty());
        Expression litNull = EncoderHelpers.lit(null, TUPLE2_TYPE);
        Expression newTuple = EncoderFactory.newInstance(Tuple2.class, TUPLE2_TYPE, EncoderHelpers.lit(idx), EncoderHelpers.deserialize((Expression)field, enc));
        return new If((Expression)new IsNull((Expression)field), litNull, newTuple);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression serializeField(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized String getterName) {
        Expression ref = (Expression)EncoderHelpers.serializer(enc).collect(ScalaInterop.match(BoundReference.class)).head();
        return EncoderHelpers.serialize(EncoderFactory.invoke(in, getterName, ref.dataType(), ref.nullable(), new Expression[0]), enc);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression deserializeField(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized int idx, @UnknownKeyFor @NonNull @Initialized String name) {
        return EncoderHelpers.deserialize((Expression)new GetStructField(in, idx, (Option)new Some((Object)name)), enc);
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Expression mapSerializer(@UnknownKeyFor @NonNull @Initialized Expression map, @UnknownKeyFor @NonNull @Initialized Encoder<K> key, @UnknownKeyFor @NonNull @Initialized Encoder<V> value) {
        DataType keyType = EncoderHelpers.deserializedType(key);
        DataType valueType = EncoderHelpers.deserializedType(value);
        return SerializerBuildHelper.createSerializerForMap((Expression)map, (SerializerBuildHelper.MapElementInformation)new SerializerBuildHelper.MapElementInformation(keyType, false, e -> EncoderHelpers.serialize(e, key)), (SerializerBuildHelper.MapElementInformation)new SerializerBuildHelper.MapElementInformation(valueType, false, e -> EncoderHelpers.serialize(e, value)));
    }

    private static <MapT extends Map<K, V>, K, V> @UnknownKeyFor @NonNull @Initialized Expression mapDeserializer(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<K> key, @UnknownKeyFor @NonNull @Initialized Encoder<V> value, @UnknownKeyFor @NonNull @Initialized Class<MapT> cls) {
        Preconditions.checkArgument((cls.isAssignableFrom(HashMap.class) || cls.equals(TreeMap.class) ? 1 : 0) != 0);
        Expression keys = EncoderHelpers.deserializeSeq((Expression)new MapKeys(in), key, false, false);
        Expression values = EncoderHelpers.deserializeSeq((Expression)new MapValues(in), value, false, false);
        String fn = cls.equals(TreeMap.class) ? "toTreeMap" : "toMap";
        return EncoderFactory.invoke(Utils.class, fn, (DataType)new ObjectType(cls), new Expression[]{keys, values, EncoderHelpers.mapItemType(key), EncoderHelpers.mapItemType(value)});
    }

    private static @UnknownKeyFor @NonNull @Initialized Literal mapItemType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> enc) {
        return EncoderHelpers.lit(EncoderHelpers.isPrimitiveEnc(enc) ? EncoderHelpers.serializedType(enc) : EncoderHelpers.deserializedType(enc), DataType.class);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression serializeSeq(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        if (EncoderHelpers.isPrimitiveEnc(enc)) {
            Expression array = EncoderFactory.invoke(in, "toArray", (DataType)new ObjectType(Object[].class), false, new Expression[0]);
            return SerializerBuildHelper.createSerializerForGenericArray((Expression)array, (DataType)EncoderHelpers.serializedType(enc), (boolean)nullable);
        }
        Expression seq = EncoderFactory.invoke(Utils.class, "toSeq", (DataType)new ObjectType(Seq.class), in);
        return MapObjects$.MODULE$.apply(exp -> EncoderHelpers.serialize(exp, enc), seq, EncoderHelpers.deserializedType(enc), nullable, Option.empty());
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression deserializeSeq(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc, @UnknownKeyFor @NonNull @Initialized boolean nullable, @UnknownKeyFor @NonNull @Initialized boolean asJava) {
        DataType type = EncoderHelpers.serializedType(enc);
        if (EncoderHelpers.isPrimitiveEnc(enc)) {
            ObjectType listType = new ObjectType(List.class);
            return asJava ? EncoderFactory.invoke(Utils.class, "toList", (DataType)listType, new Expression[]{in, EncoderHelpers.lit(type, DataType.class)}) : in;
        }
        Option optCls = asJava ? Option.apply(List.class) : Option.empty();
        return MapObjects$.MODULE$.apply(exp -> EncoderHelpers.deserialize(exp, enc), in, type, nullable, optCls);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized boolean isPrimitiveEnc(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return PRIMITIV_TYPES.contains(enc.clsTag().runtimeClass());
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression serialize(@UnknownKeyFor @NonNull @Initialized Expression input, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return (Expression)EncoderHelpers.serializer(enc).transformUp(ScalaInterop.replace(BoundReference.class, input));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression deserialize(@UnknownKeyFor @NonNull @Initialized Expression input, @UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return (Expression)EncoderHelpers.deserializer(enc).transformUp(ScalaInterop.replace(GetColumnByOrdinal.class, input));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression serializer(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return ((ExpressionEncoder)enc).objSerializer();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression deserializer(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return ((ExpressionEncoder)enc).objDeserializer();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized DataType serializedType(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return ((ExpressionEncoder)enc).objSerializer().dataType();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized DataType deserializedType(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
        return ((ExpressionEncoder)enc).objDeserializer().dataType();
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression rootRef(@UnknownKeyFor @NonNull @Initialized DataType dt, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        return new BoundReference(0, dt, nullable);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression rootCol(@UnknownKeyFor @NonNull @Initialized DataType dt) {
        return new GetColumnByOrdinal(0, dt);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression nullSafe(@UnknownKeyFor @NonNull @Initialized Expression in, @UnknownKeyFor @NonNull @Initialized Expression out) {
        return new If((Expression)new IsNull(in), EncoderHelpers.lit(null, out.dataType()), out);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression ifNotNull(@UnknownKeyFor @NonNull @Initialized Expression expr, @UnknownKeyFor @NonNull @Initialized Expression otherwise) {
        return new If((Expression)new IsNotNull(expr), expr, otherwise);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression lit(T t) {
        return Literal$.MODULE$.apply(t);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression lit(@Nullable T t, @UnknownKeyFor @NonNull @Initialized DataType dataType) {
        return new Literal(t, dataType);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Literal lit(T obj, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> cls) {
        return Literal.fromObject(obj, (DataType)new ObjectType(cls));
    }

    public static class Utils {
        public static @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfoFromBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            return (PaneInfo)CoderHelpers.fromByteArray(bytes, PaneInfo.PaneInfoCoder.of());
        }

        public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] paneInfoToBytes(@UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            return CoderHelpers.toByteArray(pane, PaneInfo.PaneInfoCoder.of());
        }

        public static @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows) {
            return ((BoundedWindow)Iterables.getOnlyElement(windows)).maxTimestamp();
        }

        public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> toList(@UnknownKeyFor @NonNull @Initialized ArrayData arrayData, @UnknownKeyFor @NonNull @Initialized DataType type) {
            return JavaConverters.seqAsJavaList((Seq)arrayData.toSeq(type));
        }

        public static @UnknownKeyFor @NonNull @Initialized Seq<@UnknownKeyFor @NonNull @Initialized Object> toSeq(@UnknownKeyFor @NonNull @Initialized ArrayData arrayData) {
            return arrayData.toSeq(OBJECT_TYPE);
        }

        public static @UnknownKeyFor @NonNull @Initialized Seq<@UnknownKeyFor @NonNull @Initialized Object> toSeq(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> col) {
            if (col instanceof List) {
                return JavaConverters.asScalaBuffer((List)((List)col));
            }
            return JavaConverters.collectionAsScalaIterable(col).toSeq();
        }

        public static @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> toTreeMap(@UnknownKeyFor @NonNull @Initialized ArrayData keys, @UnknownKeyFor @NonNull @Initialized ArrayData values, @UnknownKeyFor @NonNull @Initialized DataType keyType, @UnknownKeyFor @NonNull @Initialized DataType valueType) {
            return Utils.toMap(new TreeMap(), keys, values, keyType, valueType);
        }

        public static @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> toMap(@UnknownKeyFor @NonNull @Initialized ArrayData keys, @UnknownKeyFor @NonNull @Initialized ArrayData values, @UnknownKeyFor @NonNull @Initialized DataType keyType, @UnknownKeyFor @NonNull @Initialized DataType valueType) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)keys.numElements());
            return Utils.toMap(map, keys, values, keyType, valueType);
        }

        private static <MapT extends Map<Object, Object>> MapT toMap(MapT map, @UnknownKeyFor @NonNull @Initialized ArrayData keys, @UnknownKeyFor @NonNull @Initialized ArrayData values, @UnknownKeyFor @NonNull @Initialized DataType keyType, @UnknownKeyFor @NonNull @Initialized DataType valueType) {
            IndexedSeq keysSeq = keys.toSeq(keyType);
            IndexedSeq valuesSeq = values.toSeq(valueType);
            for (int i = 0; i < keysSeq.size(); ++i) {
                map.put((Object)keysSeq.apply(i), (Object)valuesSeq.apply(i));
            }
            return map;
        }
    }
}

