/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SparkProcessContext<@UnknownKeyFor K, @UnknownKeyFor FnInputT, @UnknownKeyFor FnOutputT, @UnknownKeyFor OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFn<FnInputT, FnOutputT> doFn;
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner;
    private final @UnknownKeyFor @NonNull @Initialized SparkOutputManager<OutputT> outputManager;
    private final @UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataIterator;
    private final K key;

    SparkProcessContext(@UnknownKeyFor @NonNull @Initialized DoFn<FnInputT, FnOutputT> doFn, @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner, @UnknownKeyFor @NonNull @Initialized SparkOutputManager<OutputT> outputManager, K key, @UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataIterator) {
        this.doFn = doFn;
        this.doFnRunner = doFnRunner;
        this.outputManager = outputManager;
        this.key = key;
        this.timerDataIterator = timerDataIterator;
    }

    @UnknownKeyFor @NonNull @Initialized Iterable<OutputT> processPartition(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> partition) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (!partition.hasNext()) {
            return new ArrayList();
        }
        return this.getOutputIterable(partition, this.doFnRunner);
    }

    private void clearOutput() {
        this.outputManager.clear();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterator<OutputT> getOutputIterator() {
        return this.outputManager.iterator();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<OutputT> getOutputIterable(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> iter, @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
        return () -> new ProcCtxtIterator(iter, doFnRunner);
    }

    private class ProcCtxtIterator
    extends AbstractIterator<OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> inputIterator;
        private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner;
        private @UnknownKeyFor @NonNull @Initialized Iterator<OutputT> outputIterator;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleStarted;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleFinished;

        ProcCtxtIterator(@UnknownKeyFor @NonNull @Initialized Iterator<WindowedValue<FnInputT>> iterator, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
            this.inputIterator = iterator;
            this.doFnRunner = doFnRunner;
            this.outputIterator = SparkProcessContext.this.getOutputIterator();
        }

        protected OutputT computeNext() {
            try {
                if (!this.isBundleStarted) {
                    this.isBundleStarted = true;
                    this.doFnRunner.startBundle();
                }
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    SparkProcessContext.this.clearOutput();
                    if (this.inputIterator.hasNext()) {
                        this.doFnRunner.processElement(this.inputIterator.next());
                        this.outputIterator = SparkProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (SparkProcessContext.this.timerDataIterator.hasNext()) {
                        this.fireTimer((TimerInternals.TimerData)SparkProcessContext.this.timerDataIterator.next());
                        this.outputIterator = SparkProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                    this.outputIterator = SparkProcessContext.this.getOutputIterator();
                }
                DoFnInvokers.invokerFor((DoFn)SparkProcessContext.this.doFn).invokeTeardown();
                return this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)SparkProcessContext.this.doFn).invokeTeardown();
                throw re;
            }
        }

        private void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            StateNamespace namespace = timer.getNamespace();
            Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
            BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
            this.doFnRunner.onTimer(timer.getTimerId(), timer.getTimerFamilyId(), SparkProcessContext.this.key, window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }
    }

    static class NoOpStepContext
    implements StepContext {
        NoOpStepContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
            throw new UnsupportedOperationException("stateInternals not supported");
        }

        public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
            throw new UnsupportedOperationException("timerInternals not supported");
        }
    }

    static interface SparkOutputManager<@UnknownKeyFor T>
    extends DoFnRunners.OutputManager,
    Iterable<T> {
        public void clear();
    }
}

