/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.stateful;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class SparkTimerInternals
implements TimerInternals {
    private final @UnknownKeyFor @NonNull @Initialized Instant highWatermark;
    private final @UnknownKeyFor @NonNull @Initialized Instant synchronizedProcessingTime;
    private final @UnknownKeyFor @NonNull @Initialized Set<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers = Sets.newHashSet();
    private @UnknownKeyFor @NonNull @Initialized Instant inputWatermark;

    private SparkTimerInternals(@UnknownKeyFor @NonNull @Initialized Instant lowWatermark, @UnknownKeyFor @NonNull @Initialized Instant highWatermark, @UnknownKeyFor @NonNull @Initialized Instant synchronizedProcessingTime) {
        this.inputWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.synchronizedProcessingTime = synchronizedProcessingTime;
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkTimerInternals forStreamFromSources(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> sourceIds, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized GlobalWatermarkHolder.SparkWatermarks> watermarks) {
        if (watermarks == null || watermarks.isEmpty() || Collections.disjoint(sourceIds, watermarks.keySet())) {
            return new SparkTimerInternals(BoundedWindow.TIMESTAMP_MIN_VALUE, BoundedWindow.TIMESTAMP_MIN_VALUE, new Instant(0L));
        }
        Instant slowestLowWatermark = BoundedWindow.TIMESTAMP_MAX_VALUE;
        Instant slowestHighWatermark = BoundedWindow.TIMESTAMP_MAX_VALUE;
        Instant synchronizedProcessingTime = null;
        for (Integer sourceId : sourceIds) {
            GlobalWatermarkHolder.SparkWatermarks sparkWatermarks = watermarks.get(sourceId);
            if (sparkWatermarks == null) continue;
            slowestLowWatermark = slowestLowWatermark.isBefore((ReadableInstant)sparkWatermarks.getLowWatermark()) ? slowestLowWatermark : sparkWatermarks.getLowWatermark();
            Instant instant = slowestHighWatermark = slowestHighWatermark.isBefore((ReadableInstant)sparkWatermarks.getHighWatermark()) ? slowestHighWatermark : sparkWatermarks.getHighWatermark();
            if (synchronizedProcessingTime == null) {
                synchronizedProcessingTime = sparkWatermarks.getSynchronizedProcessingTime();
                continue;
            }
            Preconditions.checkArgument((boolean)sparkWatermarks.getSynchronizedProcessingTime().equals((Object)synchronizedProcessingTime), (Object)"Synchronized time is expected to keep synchronized across sources.");
        }
        return new SparkTimerInternals(slowestLowWatermark, slowestHighWatermark, synchronizedProcessingTime);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkTimerInternals global(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized GlobalWatermarkHolder.SparkWatermarks> watermarks) {
        return watermarks == null ? SparkTimerInternals.forStreamFromSources(Collections.emptyList(), null) : SparkTimerInternals.forStreamFromSources(Lists.newArrayList(watermarks.keySet()), watermarks);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getTimers() {
        return this.timers;
    }

    void addTimers(@UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers) {
        while (timers.hasNext()) {
            TimerInternals.TimerData timer = timers.next();
            this.timers.add(timer);
        }
    }

    public void setTimer(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        this.timers.add(timer);
    }

    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Deleting a timer by ID is not yet supported.");
    }

    public void deleteTimer(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        this.timers.remove(timer);
    }

    public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
        return Instant.now();
    }

    public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
        return this.synchronizedProcessingTime;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
        return this.inputWatermark;
    }

    public void advanceWatermark() {
        this.inputWatermark = this.highWatermark;
    }

    public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
        return null;
    }

    public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Setting a timer by ID not yet supported.");
    }

    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        throw new UnsupportedOperationException("Deleting a timer by ID is not yet supported.");
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serializeTimers(@UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerDataCoderV2 timerDataCoder) {
        return CoderHelpers.toByteArrays(timers, timerDataCoder);
    }

    public static @UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> deserializeTimers(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serTimers, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerDataCoderV2 timerDataCoder) {
        return CoderHelpers.fromByteArrays(serTimers, timerDataCoder).iterator();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SparkTimerInternals{highWatermark=" + this.highWatermark + ", synchronizedProcessingTime=" + this.synchronizedProcessingTime + ", timers=" + this.timers + ", inputWatermark=" + this.inputWatermark + '}';
    }
}

