/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.aggregators;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.spark.repackaged.com.google.common.base.Function;
import org.apache.beam.spark.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.spark.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.spark.repackaged.com.google.common.collect.Maps;

public class NamedAggregators
implements Serializable {
    private final Map<String, State<?, ?, ?>> mNamedAggregators = new TreeMap();

    public NamedAggregators() {
    }

    public NamedAggregators(String name, State<?, ?, ?> state) {
        this.mNamedAggregators.put(name, state);
    }

    public <T> T getValue(String name, Class<T> typeClass) {
        State<?, ?, ?> state = this.mNamedAggregators.get(name);
        return state != null ? (T)typeClass.cast(state.render()) : null;
    }

    public Map<String, ?> renderAll() {
        return ImmutableMap.copyOf(Maps.transformValues(this.mNamedAggregators, new Function<State<?, ?, ?>, Object>(){

            @Override
            public Object apply(State<?, ?, ?> state) {
                return state.render();
            }
        }));
    }

    public NamedAggregators merge(NamedAggregators other) {
        for (Map.Entry<String, State<?, ?, ?>> e : other.mNamedAggregators.entrySet()) {
            String key = e.getKey();
            State<?, ?, ?> otherValue = e.getValue();
            State<?, ?, ?> value = this.mNamedAggregators.get(key);
            if (value == null) {
                this.mNamedAggregators.put(key, otherValue);
                continue;
            }
            this.mNamedAggregators.put(key, NamedAggregators.merge(value, otherValue));
        }
        return this;
    }

    private static <InputT, InterT, OutputT> State<InputT, InterT, OutputT> merge(State<?, ?, ?> s1, State<?, ?, ?> s2) {
        return s1.merge(s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, State<?, ?, ?>> e : this.mNamedAggregators.entrySet()) {
            sb.append(e.getKey()).append(": ").append(e.getValue().render()).append(" ");
        }
        return sb.toString();
    }

    public static class CombineFunctionState<InputT, InterT, OutputT>
    implements State<InputT, InterT, OutputT> {
        private Combine.CombineFn<InputT, InterT, OutputT> combineFn;
        private Coder<InputT> inCoder;
        private SparkRuntimeContext ctxt;
        private transient InterT state;

        public CombineFunctionState(Combine.CombineFn<InputT, InterT, OutputT> combineFn, Coder<InputT> inCoder, SparkRuntimeContext ctxt) {
            this.combineFn = combineFn;
            this.inCoder = inCoder;
            this.ctxt = ctxt;
            this.state = combineFn.createAccumulator();
        }

        @Override
        public void update(InputT element) {
            this.combineFn.addInput(this.state, element);
        }

        @Override
        public State<InputT, InterT, OutputT> merge(State<InputT, InterT, OutputT> other) {
            this.state = this.combineFn.mergeAccumulators(ImmutableList.of(this.current(), other.current()));
            return this;
        }

        @Override
        public InterT current() {
            return this.state;
        }

        @Override
        public OutputT render() {
            return (OutputT)this.combineFn.extractOutput(this.state);
        }

        @Override
        public Combine.CombineFn<InputT, InterT, OutputT> getCombineFn() {
            return this.combineFn;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.ctxt);
            oos.writeObject(this.combineFn);
            oos.writeObject(this.inCoder);
            try {
                this.combineFn.getAccumulatorCoder(this.ctxt.getCoderRegistry(), this.inCoder).encode(this.state, (OutputStream)oos, Coder.Context.NESTED);
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalStateException("Could not determine coder for accumulator", e);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.ctxt = (SparkRuntimeContext)ois.readObject();
            this.combineFn = (Combine.CombineFn)ois.readObject();
            this.inCoder = (Coder)ois.readObject();
            try {
                this.state = this.combineFn.getAccumulatorCoder(this.ctxt.getCoderRegistry(), this.inCoder).decode((InputStream)ois, Coder.Context.NESTED);
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalStateException("Could not determine coder for accumulator", e);
            }
        }
    }

    public static interface State<InputT, InterT, OutputT>
    extends Serializable {
        public void update(InputT var1);

        public State<InputT, InterT, OutputT> merge(State<InputT, InterT, OutputT> var1);

        public InterT current();

        public OutputT render();

        public Combine.CombineFn<InputT, InterT, OutputT> getCombineFn();
    }
}

