/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.aggregators;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.core.AggregatorFactory;
import org.apache.beam.runners.core.ExecutionContext;
import org.apache.beam.runners.spark.aggregators.AggregatorsAccumulator;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.sdk.AggregatorValues;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.spark.repackaged.com.google.common.base.Optional;
import org.apache.beam.spark.repackaged.com.google.common.collect.ImmutableList;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkAggregators {
    private static <T> AggregatorValues<T> valueOf(Accumulator<NamedAggregators> accum, Aggregator<?, T> aggregator) {
        Class valueType = aggregator.getCombineFn().getOutputType().getRawType();
        final T value = SparkAggregators.valueOf(accum, aggregator.getName(), valueType);
        return new AggregatorValues<T>(){

            public Collection<T> getValues() {
                return ImmutableList.of(value);
            }

            public Map<String, T> getValuesAtSteps() {
                throw new UnsupportedOperationException("getValuesAtSteps is not supported.");
            }
        };
    }

    private static <T> T valueOf(Accumulator<NamedAggregators> accum, String aggregatorName, Class<T> typeClass) {
        return ((NamedAggregators)accum.value()).getValue(aggregatorName, typeClass);
    }

    public static Accumulator<NamedAggregators> getNamedAggregators(JavaSparkContext jsc) {
        return SparkAggregators.getOrCreateNamedAggregators(jsc, Optional.absent());
    }

    public static Accumulator<NamedAggregators> getOrCreateNamedAggregators(JavaSparkContext jsc, Optional<Checkpoint.CheckpointDir> checkpointDir) {
        return AggregatorsAccumulator.getInstance(jsc, checkpointDir);
    }

    public static <T> AggregatorValues<T> valueOf(Aggregator<?, T> aggregator, JavaSparkContext javaSparkContext) {
        return SparkAggregators.valueOf(SparkAggregators.getNamedAggregators(javaSparkContext), aggregator);
    }

    public static <T> T valueOf(String name, Class<T> typeClass, JavaSparkContext javaSparkContext) {
        return SparkAggregators.valueOf(SparkAggregators.getNamedAggregators(javaSparkContext), name, typeClass);
    }

    public static class Factory
    implements AggregatorFactory {
        private final SparkRuntimeContext runtimeContext;
        private final Accumulator<NamedAggregators> accumulator;

        public Factory(SparkRuntimeContext runtimeContext, Accumulator<NamedAggregators> accumulator) {
            this.runtimeContext = runtimeContext;
            this.accumulator = accumulator;
        }

        public <InputT, AccumT, OutputT> Aggregator<InputT, OutputT> createAggregatorForDoFn(Class<?> fnClass, ExecutionContext.StepContext stepContext, String aggregatorName, Combine.CombineFn<InputT, AccumT, OutputT> combine) {
            return this.runtimeContext.createAggregator(this.accumulator, aggregatorName, combine);
        }
    }
}

