/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.Serializable;
import java.util.Collections;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceDStream;
import org.apache.beam.runners.spark.stateful.StateSpecFunctions;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public class SparkUnboundedSource {
    public static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> UnboundedDataset<T> read(JavaStreamingContext jssc, SparkRuntimeContext rc, UnboundedSource<T, CheckpointMarkT> source) {
        SparkPipelineOptions options = (SparkPipelineOptions)rc.getPipelineOptions().as(SparkPipelineOptions.class);
        Long maxRecordsPerBatch = options.getMaxRecordsPerBatch();
        SourceDStream<T, CheckpointMarkT> sourceDStream = new SourceDStream<T, CheckpointMarkT>(jssc.ssc(), source, rc);
        if (maxRecordsPerBatch > 0L) {
            sourceDStream.setMaxRecordsPerBatch(maxRecordsPerBatch);
        }
        JavaPairInputDStream inputDStream = JavaPairInputDStream$.MODULE$.fromInputDStream(sourceDStream, JavaSparkContext$.MODULE$.fakeClassTag(), JavaSparkContext$.MODULE$.fakeClassTag());
        JavaMapWithStateDStream mapWithStateDStream = inputDStream.mapWithState(StateSpec.function(StateSpecFunctions.mapSourceFunction(rc)));
        SparkUnboundedSource.checkpointStream(mapWithStateDStream, options);
        int id = inputDStream.inputDStream().id();
        JavaDStream metadataDStream = mapWithStateDStream.map((Function)new Function<Tuple2<Iterable<byte[]>, Metadata>, Metadata>(){

            public Metadata call(Tuple2<Iterable<byte[]>, Metadata> t2) throws Exception {
                return (Metadata)t2._2();
            }
        });
        new ReportingDStream((DStream<Metadata>)metadataDStream.dstream(), id, SparkUnboundedSource.getSourceName(source, id)).register();
        WindowedValue.FullWindowedValueCoder coder = WindowedValue.FullWindowedValueCoder.of((Coder)source.getDefaultOutputCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        JavaDStream readUnboundedStream = mapWithStateDStream.flatMap((FlatMapFunction)new FlatMapFunction<Tuple2<Iterable<byte[]>, Metadata>, byte[]>(){

            public Iterable<byte[]> call(Tuple2<Iterable<byte[]>, Metadata> t2) throws Exception {
                return (Iterable)t2._1();
            }
        }).map(CoderHelpers.fromByteFunction(coder));
        return new UnboundedDataset(readUnboundedStream, Collections.singletonList(id));
    }

    private static <T> String getSourceName(Source<T> source, int id) {
        StringBuilder sb = new StringBuilder();
        for (String s : source.getClass().getSimpleName().replace("$", "").split("(?=[A-Z])")) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            sb.append(trimmed).append(" ");
        }
        return sb.append("[").append(id).append("]").toString();
    }

    private static void checkpointStream(JavaDStream<?> dStream, SparkPipelineOptions options) {
        long checkpointDurationMillis = options.getCheckpointDurationMillis();
        if (checkpointDurationMillis > 0L) {
            dStream.checkpoint(new Duration(checkpointDurationMillis));
        }
    }

    public static class Metadata
    implements Serializable {
        private final long numRecords;
        private final Instant lowWatermark;
        private final Instant highWatermark;

        public Metadata(long numRecords, Instant lowWatermark, Instant highWatermark) {
            this.numRecords = numRecords;
            this.lowWatermark = lowWatermark;
            this.highWatermark = highWatermark;
        }

        public long getNumRecords() {
            return this.numRecords;
        }

        public Instant getLowWatermark() {
            return this.lowWatermark;
        }

        public Instant getHighWatermark() {
            return this.highWatermark;
        }
    }

    private static class ReportingDStream
    extends DStream<BoxedUnit> {
        private final DStream<Metadata> parent;
        private final int inputDStreamId;
        private final String sourceName;

        ReportingDStream(DStream<Metadata> parent, int inputDStreamId, String sourceName) {
            super(parent.ssc(), JavaSparkContext$.MODULE$.fakeClassTag());
            this.parent = parent;
            this.inputDStreamId = inputDStreamId;
            this.sourceName = sourceName;
        }

        public Duration slideDuration() {
            return this.parent.slideDuration();
        }

        public List<DStream<?>> dependencies() {
            return JavaConversions.asScalaBuffer(Collections.singletonList(this.parent)).toList();
        }

        public Option<RDD<BoxedUnit>> compute(Time validTime) {
            Option parentRDDOpt = this.parent.getOrCompute(validTime);
            long count = 0L;
            GlobalWatermarkHolder.SparkWatermarks sparkWatermark = null;
            Instant globalLowWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            Instant globalHighWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            if (parentRDDOpt.isDefined()) {
                JavaRDD parentRDD = ((RDD)parentRDDOpt.get()).toJavaRDD();
                for (Metadata metadata : parentRDD.collect()) {
                    count += metadata.getNumRecords();
                    Instant partitionLowWatermark = metadata.getLowWatermark();
                    globalLowWatermarkForBatch = globalLowWatermarkForBatch.isBefore((ReadableInstant)partitionLowWatermark) ? partitionLowWatermark : globalLowWatermarkForBatch;
                    Instant partitionHighWatermark = metadata.getHighWatermark();
                    globalHighWatermarkForBatch = globalHighWatermarkForBatch.isBefore((ReadableInstant)partitionHighWatermark) ? partitionHighWatermark : globalHighWatermarkForBatch;
                }
                sparkWatermark = new GlobalWatermarkHolder.SparkWatermarks(globalLowWatermarkForBatch, globalHighWatermarkForBatch, new Instant(validTime.milliseconds()));
                GlobalWatermarkHolder.add(this.inputDStreamId, sparkWatermark);
            }
            this.report(validTime, count, sparkWatermark);
            return Option.empty();
        }

        private void report(Time batchTime, long count, GlobalWatermarkHolder.SparkWatermarks sparkWatermark) {
            Map.Map1 metadata = new Map.Map1((Object)StreamInputInfo.METADATA_KEY_DESCRIPTION(), (Object)String.format("Read %d records with observed watermarks %s, from %s for batch time: %s", count, sparkWatermark == null ? "N/A" : sparkWatermark, this.sourceName, batchTime));
            StreamInputInfo streamInputInfo = new StreamInputInfo(this.inputDStreamId, count, (Map)metadata);
            this.ssc().scheduler().inputInfoTracker().reportInfo(batchTime, streamInputInfo);
        }
    }
}

